/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import com.brunomnsilva.smartgraph.graphview.SmartStyleProxy;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;

public class SmartLabel
extends Text
implements SmartStylableNode {
    private final SmartStyleProxy styleProxy = new SmartStyleProxy((Shape)this);
    private final DoubleProperty layoutWidth = new SimpleDoubleProperty();
    private final DoubleProperty layoutHeight = new SimpleDoubleProperty();

    public SmartLabel(String text) {
        this(0.0, 0.0, text);
    }

    public SmartLabel(double x, double y, String text) {
        super(x, y, text);
        this.layoutBoundsProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null) {
                if (Double.compare(this.layoutWidth.doubleValue(), newValue.getWidth()) != 0) {
                    this.layoutWidth.set(newValue.getWidth());
                }
                if (Double.compare(this.layoutHeight.doubleValue(), newValue.getHeight()) != 0) {
                    this.layoutHeight.set(newValue.getHeight());
                }
            }
        });
    }

    public ReadOnlyDoubleProperty layoutWidthProperty() {
        return this.layoutWidth;
    }

    public ReadOnlyDoubleProperty layoutHeightProperty() {
        return this.layoutHeight;
    }

    public void setText_(String text) {
        if (this.getText().compareTo(text) != 0) {
            this.setText(text);
        }
    }

    @Override
    public void setStyleInline(String css) {
        this.styleProxy.setStyleInline(css);
    }

    @Override
    public void setStyleClass(String cssClass) {
        this.styleProxy.setStyleClass(cssClass);
    }

    @Override
    public void addStyleClass(String cssClass) {
        this.styleProxy.addStyleClass(cssClass);
    }

    @Override
    public boolean removeStyleClass(String cssClass) {
        return this.styleProxy.removeStyleClass(cssClass);
    }
}

