/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmartGraphProperties {
    private static final boolean DEFAULT_VERTEX_ALLOW_USER_MOVE = true;
    private static final String PROPERTY_VERTEX_ALLOW_USER_MOVE = "vertex.allow-user-move";
    private static final double DEFAULT_VERTEX_RADIUS = 15.0;
    private static final String PROPERTY_VERTEX_RADIUS = "vertex.radius";
    private static final String DEFAULT_VERTEX_SHAPE = "circle";
    private static final String PROPERTY_VERTEX_SHAPE = "vertex.shape";
    private static final boolean DEFAULT_VERTEX_USE_TOOLTIP = true;
    private static final String PROPERTY_VERTEX_USE_TOOLTIP = "vertex.tooltip";
    private static final boolean DEFAULT_VERTEX_USE_LABEL = true;
    private static final String PROPERTY_VERTEX_USE_LABEL = "vertex.label";
    private static final boolean DEFAULT_EDGE_USE_TOOLTIP = true;
    private static final String PROPERTY_EDGE_USE_TOOLTIP = "edge.tooltip";
    private static final boolean DEFAULT_EDGE_USE_LABEL = true;
    private static final String PROPERTY_EDGE_USE_LABEL = "edge.label";
    private static final boolean DEFAULT_EDGE_USE_ARROW = true;
    private static final String PROPERTY_EDGE_USE_ARROW = "edge.arrow";
    private static final int DEFAULT_ARROW_SIZE = 5;
    private static final String PROPERTY_ARROW_SIZE = "edge.arrowsize";
    private static final double DEFAULT_REPULSION_FORCE = 25000.0;
    private static final String PROPERTY_REPULSION_FORCE = "layout.repulsive-force";
    private static final double DEFAULT_ATTRACTION_FORCE = 30.0;
    private static final String PROPERTY_ATTRACTION_FORCE = "layout.attraction-force";
    private static final double DEFAULT_ATTRACTION_SCALE = 10.0;
    private static final String PROPERTY_ATTRACTION_SCALE = "layout.attraction-scale";
    private static final String DEFAULT_FILE = "smartgraph.properties";
    private final Properties properties = new Properties();

    public SmartGraphProperties() {
        try {
            this.properties.load(new FileInputStream(DEFAULT_FILE));
        }
        catch (IOException ex) {
            String msg = String.format("The default %s was not found. Using default values.", DEFAULT_FILE);
            Logger.getLogger(SmartGraphProperties.class.getName()).log(Level.WARNING, msg);
        }
    }

    public SmartGraphProperties(InputStream inputStream) {
        try {
            this.properties.load(inputStream);
        }
        catch (IOException ex) {
            String msg = "The file provided by the input stream does not exist. Using default values.";
            Logger.getLogger(SmartGraphProperties.class.getName()).log(Level.WARNING, msg);
        }
    }

    public SmartGraphProperties(String content) {
        try {
            ByteArrayInputStream targetStream = new ByteArrayInputStream(content.getBytes());
            this.properties.load(targetStream);
        }
        catch (IOException ex) {
            String msg = "The string contents could not be loaded. Using default values.";
            Logger.getLogger(SmartGraphProperties.class.getName()).log(Level.WARNING, msg);
        }
    }

    public boolean getVertexAllowUserMove() {
        return this.getBooleanProperty(PROPERTY_VERTEX_ALLOW_USER_MOVE, true);
    }

    public double getVertexRadius() {
        return this.getDoubleProperty(PROPERTY_VERTEX_RADIUS, 15.0);
    }

    public String getVertexShape() {
        return this.getStringProperty(PROPERTY_VERTEX_SHAPE, DEFAULT_VERTEX_SHAPE);
    }

    public double getRepulsionForce() {
        return this.getDoubleProperty(PROPERTY_REPULSION_FORCE, 25000.0);
    }

    public double getAttractionForce() {
        return this.getDoubleProperty(PROPERTY_ATTRACTION_FORCE, 30.0);
    }

    public double getAttractionScale() {
        return this.getDoubleProperty(PROPERTY_ATTRACTION_SCALE, 10.0);
    }

    public boolean getUseVertexTooltip() {
        return this.getBooleanProperty(PROPERTY_VERTEX_USE_TOOLTIP, true);
    }

    public boolean getUseVertexLabel() {
        return this.getBooleanProperty(PROPERTY_VERTEX_USE_LABEL, true);
    }

    public boolean getUseEdgeTooltip() {
        return this.getBooleanProperty(PROPERTY_EDGE_USE_TOOLTIP, true);
    }

    public boolean getUseEdgeLabel() {
        return this.getBooleanProperty(PROPERTY_EDGE_USE_LABEL, true);
    }

    public boolean getUseEdgeArrow() {
        return this.getBooleanProperty(PROPERTY_EDGE_USE_ARROW, true);
    }

    public double getEdgeArrowSize() {
        return this.getDoubleProperty(PROPERTY_ARROW_SIZE, 5.0);
    }

    private double getDoubleProperty(String propertyName, double defaultValue) {
        String p = this.properties.getProperty(propertyName, Double.toString(defaultValue));
        try {
            return Double.parseDouble(p);
        }
        catch (NumberFormatException e) {
            System.err.printf("Error in reading property %s: %s", propertyName, e.getMessage());
            return defaultValue;
        }
    }

    private boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        String p = this.properties.getProperty(propertyName, Boolean.toString(defaultValue));
        try {
            return Boolean.parseBoolean(p);
        }
        catch (NumberFormatException e) {
            System.err.printf("Error in reading property %s: %s", propertyName, e.getMessage());
            return defaultValue;
        }
    }

    private String getStringProperty(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public static void main(String[] args) {
        SmartGraphProperties props = new SmartGraphProperties();
        System.out.println("Prop vertex radius: " + props.getVertexRadius());
        System.out.println("Prop vertex shape: " + props.getVertexShape());
    }
}

