/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ShapeCircle;
import com.brunomnsilva.smartgraph.graphview.ShapeRegularPolygon;
import com.brunomnsilva.smartgraph.graphview.ShapeStar;
import com.brunomnsilva.smartgraph.graphview.ShapeWithRadius;

public class ShapeFactory {
    public static ShapeWithRadius<?> create(String type, double x, double y, double radius) {
        Args.requireNonNegative(x, "x");
        Args.requireNonNegative(y, "y");
        Args.requireNonNegative(radius, "radius");
        switch (type = type.trim().toLowerCase()) {
            case "star": {
                return new ShapeStar(x, y, radius);
            }
            case "circle": {
                return new ShapeCircle(x, y, radius);
            }
            case "triangle": {
                return new ShapeRegularPolygon(x, y, radius, 3);
            }
            case "square": {
                return new ShapeRegularPolygon(x, y, radius, 4);
            }
            case "pentagon": {
                return new ShapeRegularPolygon(x, y, radius, 5);
            }
            case "hexagon": {
                return new ShapeRegularPolygon(x, y, radius, 6);
            }
            case "heptagon": {
                return new ShapeRegularPolygon(x, y, radius, 7);
            }
            case "octagon": {
                return new ShapeRegularPolygon(x, y, radius, 8);
            }
            case "nonagon": {
                return new ShapeRegularPolygon(x, y, radius, 9);
            }
            case "decagon": {
                return new ShapeRegularPolygon(x, y, radius, 10);
            }
            case "hendecagon": {
                return new ShapeRegularPolygon(x, y, radius, 11);
            }
            case "dodecagon": {
                return new ShapeRegularPolygon(x, y, radius, 12);
            }
        }
        throw new IllegalArgumentException("Invalid shape type. See javadoc for available shapes.");
    }
}

