/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ForceDirectedSpringSystemLayoutStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertexNode;
import java.util.Collection;
import javafx.geometry.Point2D;

public class ForceDirectedSpringGravityLayoutStrategy<V>
extends ForceDirectedSpringSystemLayoutStrategy<V> {
    private final double gravity;

    public ForceDirectedSpringGravityLayoutStrategy() {
        this.gravity = 0.01;
    }

    public ForceDirectedSpringGravityLayoutStrategy(double repulsiveForce, double attractionForce, double attractionScale, double acceleration, double gravity) {
        super(repulsiveForce, attractionForce, attractionScale, acceleration);
        Args.requireGreaterThan(gravity, "gravity", 0.0);
        Args.requireInRange(gravity, "gravity", 0.0, 1.0);
        this.gravity = gravity;
    }

    @Override
    public void computeForces(Collection<SmartGraphVertexNode<V>> nodes, double panelWidth, double panelHeight) {
        for (SmartGraphVertexNode<V> v : nodes) {
            for (SmartGraphVertexNode<V> w : nodes) {
                if (v == w) continue;
                Point2D force = this.computeForceBetween(v, w, panelWidth, panelHeight);
                v.addForceVector(force.getX(), force.getY());
            }
        }
        double centerX = panelWidth / 2.0;
        double centerY = panelHeight / 2.0;
        for (SmartGraphVertexNode<V> v : nodes) {
            Point2D curPosition = v.getUpdatedPosition();
            Point2D forceCenter = new Point2D(centerX - curPosition.getX(), centerY - curPosition.getY()).multiply(this.gravity);
            v.addForceVector(forceCenter.getX(), forceCenter.getY());
        }
    }
}

