/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.containers;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;

public class ContentZoomScrollPane
extends ScrollPane {
    public static final double MIN_SCALE = 1.0;
    public static final double MAX_SCALE = 5.0;
    public static final double SCROLL_DELTA = 0.25;
    private final Pane content;
    private final DoubleProperty scaleFactorProperty;
    private final double minScaleFactor;
    private final double maxScaleFactor;
    private final double deltaScaleFactor;
    private PreferredSize contentPreferredSize;

    public ContentZoomScrollPane(Pane content, double maxScaleFactor, double deltaScaleFactor) {
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null.");
        }
        if (maxScaleFactor < 1.0) {
            throw new IllegalArgumentException("Maximum scale factor must be >= 1.");
        }
        if (deltaScaleFactor <= 0.0) {
            throw new IllegalArgumentException("Delta scale factor must be > 0.");
        }
        this.content = content;
        Group contentGroup = new Group();
        contentGroup.getChildren().add((Object)this.content);
        this.setContent((Node)contentGroup);
        this.minScaleFactor = 1.0;
        this.maxScaleFactor = maxScaleFactor;
        this.deltaScaleFactor = deltaScaleFactor;
        this.scaleFactorProperty = new ReadOnlyDoubleWrapper(this.minScaleFactor);
        this.enableContentResize();
        this.enableZoom();
        this.enablePanning();
    }

    public ContentZoomScrollPane(Pane content) {
        this(content, 5.0, 0.25);
    }

    public DoubleProperty scaleFactorProperty() {
        return this.scaleFactorProperty;
    }

    public double getMinScaleFactor() {
        return this.minScaleFactor;
    }

    public double getMaxScaleFactor() {
        return this.maxScaleFactor;
    }

    public double getDeltaScaleFactor() {
        return this.deltaScaleFactor;
    }

    private void enableContentResize() {
        this.contentPreferredSize = new PreferredSize(this.content.getPrefWidth(), this.content.getPrefHeight());
        this.viewportBoundsProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.contentPreferredSize.isWidthSet() && newValue.getWidth() > 0.0) {
                this.content.setPrefWidth(newValue.getWidth());
            }
            if (!this.contentPreferredSize.isHeightSet() && newValue.getHeight() > 0.0) {
                this.content.setPrefHeight(newValue.getHeight());
            }
        });
    }

    private void enablePanning() {
        this.setPannable(true);
    }

    private void enableZoom() {
        this.addEventFilter(ScrollEvent.ANY, event -> {
            if (event.getDeltaY() > 0.0) {
                this.zoomIn((ScrollEvent)event);
            } else {
                this.zoomOut((ScrollEvent)event);
            }
            event.consume();
        });
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }

    private void zoomOut(ScrollEvent event) {
        this.zoomContent(event.getX(), event.getY(), ZoomDirection.OUT);
    }

    private void zoomIn(ScrollEvent event) {
        this.zoomContent(event.getX(), event.getY(), ZoomDirection.IN);
    }

    private void zoomContent(double pivotX, double pivotY, ZoomDirection direction) {
        double previousScale = this.scaleFactorProperty.doubleValue();
        double nextScale = previousScale + (double)direction.getValue() * this.deltaScaleFactor;
        double scaleFactor = nextScale / previousScale;
        double scaleTotal = this.scaleFactorProperty.doubleValue() * scaleFactor;
        if (scaleTotal >= this.minScaleFactor && scaleTotal <= this.maxScaleFactor) {
            Bounds viewPort = this.getViewportBounds();
            Bounds contentSize = this.content.getBoundsInParent();
            Point2D zoomCenter = this.content.sceneToLocal(pivotX, pivotY);
            double centerPosX = (contentSize.getWidth() - viewPort.getWidth()) * this.getHvalue() + zoomCenter.getX();
            double centerPosY = (contentSize.getHeight() - viewPort.getHeight()) * this.getVvalue() + zoomCenter.getY();
            this.content.setScaleX(scaleTotal);
            this.content.setScaleY(scaleTotal);
            double newCenterX = centerPosX * scaleFactor;
            double newCenterY = centerPosY * scaleFactor;
            double h = (newCenterX - zoomCenter.getX()) / (contentSize.getWidth() * scaleFactor - viewPort.getWidth());
            double v = (newCenterY - zoomCenter.getY()) / (contentSize.getHeight() * scaleFactor - viewPort.getHeight());
            if (Double.isInfinite(h) || Double.isNaN(h) || Double.isInfinite(v) || Double.isNaN(v)) {
                return;
            }
            this.setHvalue(h);
            this.setVvalue(v);
            this.scaleFactorProperty.set(scaleTotal);
        }
    }

    private static class PreferredSize {
        public double width;
        public double height;

        public PreferredSize(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isWidthSet() {
            return this.getWidth() != -1.0;
        }

        public boolean isHeightSet() {
            return this.getHeight() != -1.0;
        }
    }

    private static enum ZoomDirection {
        IN(1),
        OUT(-1);

        private final int value;

        private ZoomDirection(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

