/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.pickerview.popwindow;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.PopupWindow;
import com.bruce.pickerview.LoopScrollListener;
import com.bruce.pickerview.LoopView;
import com.bruce.pickerview.R;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DatePickerPopWin
extends PopupWindow
implements View.OnClickListener {
    private static final int DEFAULT_MIN_YEAR = 1900;
    public Button cancelBtn;
    public Button confirmBtn;
    public LoopView yearLoopView;
    public LoopView monthLoopView;
    public LoopView dayLoopView;
    public View pickerContainerV;
    public View contentView;
    private int minYear;
    private int maxYear;
    private int yearPos = 0;
    private int monthPos = 0;
    private int dayPos = 0;
    private Context mContext;
    private String textCancel;
    private String textConfirm;
    private int colorCancel;
    private int colorConfirm;
    private int btnTextsize;
    private int viewTextSize;
    private boolean showDayMonthYear;
    List<String> yearList = new ArrayList<String>();
    List<String> monthList = new ArrayList<String>();
    List<String> dayList = new ArrayList<String>();
    private OnDatePickedListener mListener;

    public DatePickerPopWin(Builder builder) {
        this.minYear = builder.minYear;
        this.maxYear = builder.maxYear;
        this.textCancel = builder.textCancel;
        this.textConfirm = builder.textConfirm;
        this.mContext = builder.context;
        this.mListener = builder.listener;
        this.colorCancel = builder.colorCancel;
        this.colorConfirm = builder.colorConfirm;
        this.btnTextsize = builder.btnTextSize;
        this.viewTextSize = builder.viewTextSize;
        this.showDayMonthYear = builder.showDayMonthYear;
        this.setSelectedDate(builder.dateChose);
        this.initView();
    }

    private void initView() {
        this.contentView = LayoutInflater.from((Context)this.mContext).inflate(this.showDayMonthYear ? R.layout.layout_date_picker_inverted : R.layout.layout_date_picker, null);
        this.cancelBtn = (Button)this.contentView.findViewById(R.id.btn_cancel);
        this.confirmBtn = (Button)this.contentView.findViewById(R.id.btn_confirm);
        this.yearLoopView = (LoopView)this.contentView.findViewById(R.id.picker_year);
        this.monthLoopView = (LoopView)this.contentView.findViewById(R.id.picker_month);
        this.dayLoopView = (LoopView)this.contentView.findViewById(R.id.picker_day);
        this.pickerContainerV = this.contentView.findViewById(R.id.container_picker);
        this.yearLoopView.setLoopListener(new LoopScrollListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.yearPos = item;
                DatePickerPopWin.this.initDayPickerView();
            }
        });
        this.monthLoopView.setLoopListener(new LoopScrollListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.monthPos = item;
                DatePickerPopWin.this.initDayPickerView();
            }
        });
        this.dayLoopView.setLoopListener(new LoopScrollListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.dayPos = item;
            }
        });
        this.initPickerViews();
        this.initDayPickerView();
        this.cancelBtn.setOnClickListener((View.OnClickListener)this);
        this.confirmBtn.setOnClickListener((View.OnClickListener)this);
        this.contentView.setOnClickListener((View.OnClickListener)this);
        if (!TextUtils.isEmpty((CharSequence)this.textConfirm)) {
            this.confirmBtn.setText((CharSequence)this.textConfirm);
        }
        if (!TextUtils.isEmpty((CharSequence)this.textCancel)) {
            this.cancelBtn.setText((CharSequence)this.textCancel);
        }
        this.setTouchable(true);
        this.setFocusable(true);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.setAnimationStyle(R.style.FadeInPopWin);
        this.setContentView(this.contentView);
        this.setWidth(-1);
        this.setHeight(-1);
    }

    private void initPickerViews() {
        int yearCount = this.maxYear - this.minYear;
        for (int i = 0; i < yearCount; ++i) {
            this.yearList.add(DatePickerPopWin.format2LenStr(this.minYear + i));
        }
        for (int j = 0; j < 12; ++j) {
            this.monthList.add(DatePickerPopWin.format2LenStr(j + 1));
        }
        this.yearLoopView.setDataList((ArrayList)this.yearList);
        this.yearLoopView.setInitPosition(this.yearPos);
        this.monthLoopView.setDataList((ArrayList)this.monthList);
        this.monthLoopView.setInitPosition(this.monthPos);
    }

    private void initDayPickerView() {
        Calendar calendar = Calendar.getInstance();
        this.dayList = new ArrayList<String>();
        calendar.set(1, this.minYear + this.yearPos);
        calendar.set(2, this.monthPos);
        int dayMaxInMonth = calendar.getActualMaximum(5);
        for (int i = 0; i < dayMaxInMonth; ++i) {
            this.dayList.add(DatePickerPopWin.format2LenStr(i + 1));
        }
        this.dayLoopView.setDataList((ArrayList)this.dayList);
        this.dayLoopView.setInitPosition(this.dayPos);
    }

    public void setSelectedDate(String dateStr) {
        if (!TextUtils.isEmpty((CharSequence)dateStr)) {
            long milliseconds = DatePickerPopWin.getLongFromyyyyMMdd(dateStr);
            Calendar calendar = Calendar.getInstance(Locale.CHINA);
            if (milliseconds != -1L) {
                calendar.setTimeInMillis(milliseconds);
                this.yearPos = calendar.get(1) - this.minYear;
                this.monthPos = calendar.get(2);
                this.dayPos = calendar.get(5) - 1;
            }
        }
    }

    public void showPopWin(Activity activity) {
        if (null != activity) {
            TranslateAnimation trans = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
            this.showAtLocation(activity.getWindow().getDecorView(), 80, 0, 0);
            trans.setDuration(400L);
            trans.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            this.pickerContainerV.startAnimation((Animation)trans);
        }
    }

    public void dismissPopWin() {
        TranslateAnimation trans = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        trans.setDuration(400L);
        trans.setInterpolator((Interpolator)new AccelerateInterpolator());
        trans.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                DatePickerPopWin.this.dismiss();
            }
        });
        this.pickerContainerV.startAnimation((Animation)trans);
    }

    public void onClick(View v) {
        if (v == this.contentView || v == this.cancelBtn) {
            this.dismissPopWin();
        } else if (v == this.confirmBtn) {
            if (null != this.mListener) {
                int year = this.minYear + this.yearPos;
                int month = this.monthPos + 1;
                int day = this.dayPos + 1;
                StringBuffer sb = new StringBuffer();
                sb.append(String.valueOf(year));
                sb.append("-");
                sb.append(DatePickerPopWin.format2LenStr(month));
                sb.append("-");
                sb.append(DatePickerPopWin.format2LenStr(day));
                this.mListener.onDatePickCompleted(year, month, day, sb.toString());
            }
            this.dismissPopWin();
        }
    }

    public static long getLongFromyyyyMMdd(String date) {
        SimpleDateFormat mFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Date parse = null;
        try {
            parse = mFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (parse != null) {
            return parse.getTime();
        }
        return -1L;
    }

    public static String getStrDate() {
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        return dd.format(new Date());
    }

    public static String format2LenStr(int num) {
        return num < 10 ? "0" + num : String.valueOf(num);
    }

    public static int spToPx(Context context, int spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)((float)spValue * fontScale + 0.5f);
    }

    public static interface OnDatePickedListener {
        public void onDatePickCompleted(int var1, int var2, int var3, String var4);
    }

    public static class Builder {
        private Context context;
        private OnDatePickedListener listener;
        private boolean showDayMonthYear = false;
        private int minYear = 1900;
        private int maxYear = Calendar.getInstance().get(1) + 1;
        private String textCancel = "Cancel";
        private String textConfirm = "Confirm";
        private String dateChose = DatePickerPopWin.getStrDate();
        private int colorCancel = Color.parseColor((String)"#999999");
        private int colorConfirm = Color.parseColor((String)"#303F9F");
        private int btnTextSize = 16;
        private int viewTextSize = 25;

        public Builder(Context context, OnDatePickedListener listener) {
            this.context = context;
            this.listener = listener;
        }

        public Builder minYear(int minYear) {
            this.minYear = minYear;
            return this;
        }

        public Builder maxYear(int maxYear) {
            this.maxYear = maxYear;
            return this;
        }

        public Builder textCancel(String textCancel) {
            this.textCancel = textCancel;
            return this;
        }

        public Builder textConfirm(String textConfirm) {
            this.textConfirm = textConfirm;
            return this;
        }

        public Builder dateChose(String dateChose) {
            this.dateChose = dateChose;
            return this;
        }

        public Builder colorCancel(int colorCancel) {
            this.colorCancel = colorCancel;
            return this;
        }

        public Builder colorConfirm(int colorConfirm) {
            this.colorConfirm = colorConfirm;
            return this;
        }

        public Builder btnTextSize(int textSize) {
            this.btnTextSize = textSize;
            return this;
        }

        public Builder viewTextSize(int textSize) {
            this.viewTextSize = textSize;
            return this;
        }

        public DatePickerPopWin build() {
            if (this.minYear > this.maxYear) {
                throw new IllegalArgumentException();
            }
            return new DatePickerPopWin(this);
        }

        public Builder showDayMonthYear(boolean useDayMonthYear) {
            this.showDayMonthYear = useDayMonthYear;
            return this;
        }
    }
}

