/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.pickerview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.bruce.pickerview.LoopScrollListener;
import com.bruce.pickerview.R;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LoopView
extends View {
    private static final String TAG = LoopView.class.getSimpleName();
    public static final int MSG_INVALIDATE = 1000;
    public static final int MSG_SCROLL_LOOP = 2000;
    public static final int MSG_SELECTED_ITEM = 3000;
    private ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mScheduledFuture;
    private int mTotalScrollY;
    private LoopScrollListener mLoopListener;
    private GestureDetector mGestureDetector;
    private int mSelectedItem;
    private GestureDetector.SimpleOnGestureListener mOnGestureListener;
    private Context mContext;
    private Paint mTopBottomTextPaint;
    private Paint mCenterTextPaint;
    private Paint mCenterLinePaint;
    private ArrayList mDataList;
    private int mTextSize;
    private int mMaxTextWidth;
    private int mMaxTextHeight;
    private int mTopBottomTextColor;
    private int mCenterTextColor;
    private int mCenterLineColor;
    private float lineSpacingMultiplier;
    private boolean mCanLoop;
    private int mTopLineY;
    private int mBottomLineY;
    private int mCurrentIndex;
    private int mInitPosition;
    private int mPaddingLeftRight;
    private int mPaddingTopBottom;
    private float mItemHeight;
    private int mDrawItemsCount;
    private int mCircularDiameter;
    private int mWidgetHeight;
    private int mCircularRadius;
    private int mWidgetWidth;
    public Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 1000) {
                LoopView.this.invalidate();
            }
            if (msg.what == 2000) {
                LoopView.this.startSmoothScrollTo();
            } else if (msg.what == 3000) {
                LoopView.this.itemSelected();
            }
            return false;
        }
    });

    public LoopView(Context context) {
        this(context, null);
    }

    public LoopView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoopView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @TargetApi(value=21)
    public LoopView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.LoopView);
        if (array != null) {
            this.mTopBottomTextColor = array.getColor(R.styleable.LoopView_topBottomTextColor, -5263441);
            this.mCenterTextColor = array.getColor(R.styleable.LoopView_centerTextColor, -13553359);
            this.mCenterLineColor = array.getColor(R.styleable.LoopView_lineColor, -3815995);
            this.mCanLoop = array.getBoolean(R.styleable.LoopView_canLoop, true);
            this.mInitPosition = array.getInt(R.styleable.LoopView_initPosition, -1);
            this.mTextSize = array.getDimensionPixelSize(R.styleable.LoopView_textSize, this.sp2px(context, 16.0f));
            this.mDrawItemsCount = array.getInt(R.styleable.LoopView_drawItemCount, 7);
            array.recycle();
        }
        this.lineSpacingMultiplier = 2.0f;
        this.mContext = context;
        this.mOnGestureListener = new LoopViewGestureListener();
        this.mTopBottomTextPaint = new Paint();
        this.mCenterTextPaint = new Paint();
        this.mCenterLinePaint = new Paint();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mOnGestureListener);
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    private void initData() {
        if (this.mDataList == null) {
            throw new IllegalArgumentException("data list must not be null!");
        }
        this.mTopBottomTextPaint.setColor(this.mTopBottomTextColor);
        this.mTopBottomTextPaint.setAntiAlias(true);
        this.mTopBottomTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mTopBottomTextPaint.setTextSize((float)this.mTextSize);
        this.mCenterTextPaint.setColor(this.mCenterTextColor);
        this.mCenterTextPaint.setAntiAlias(true);
        this.mCenterTextPaint.setTextScaleX(1.05f);
        this.mCenterTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mCenterTextPaint.setTextSize((float)this.mTextSize);
        this.mCenterLinePaint.setColor(this.mCenterLineColor);
        this.mCenterLinePaint.setAntiAlias(true);
        this.mCenterLinePaint.setTypeface(Typeface.MONOSPACE);
        this.mCenterLinePaint.setTextSize((float)this.mTextSize);
        this.measureTextWidthHeight();
        int mHalfCircumference = (int)((float)this.mMaxTextHeight * this.lineSpacingMultiplier * (float)(this.mDrawItemsCount - 1));
        this.mCircularDiameter = (int)((double)(mHalfCircumference * 2) / Math.PI);
        this.mCircularRadius = (int)((double)mHalfCircumference / Math.PI);
        if (this.mInitPosition == -1) {
            this.mInitPosition = this.mCanLoop ? (this.mDataList.size() + 1) / 2 : 0;
        }
        this.mCurrentIndex = this.mInitPosition;
        this.invalidate();
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.mDataList.size(); ++i) {
            int textHeight;
            String s1 = (String)this.mDataList.get(i);
            this.mCenterTextPaint.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.mMaxTextWidth) {
                this.mMaxTextWidth = textWidth;
            }
            if ((textHeight = rect.height()) <= this.mMaxTextHeight) continue;
            this.mMaxTextHeight = textHeight;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidgetWidth = this.getMeasuredWidth();
        this.mWidgetHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        Log.i((String)TAG, (String)("onMeasure -> heightMode:" + heightMode));
        this.mItemHeight = this.lineSpacingMultiplier * (float)this.mMaxTextHeight;
        this.mPaddingLeftRight = (this.mWidgetWidth - this.mMaxTextWidth) / 2;
        this.mPaddingTopBottom = (this.mWidgetHeight - this.mCircularDiameter) / 2;
        this.mTopLineY = (int)(((float)this.mCircularDiameter - this.mItemHeight) / 2.0f) + this.mPaddingTopBottom;
        this.mBottomLineY = (int)(((float)this.mCircularDiameter + this.mItemHeight) / 2.0f) + this.mPaddingTopBottom;
    }

    protected void onDraw(Canvas canvas) {
        int count;
        if (this.mDataList == null) {
            super.onDraw(canvas);
            return;
        }
        super.onDraw(canvas);
        int mChangingItem = (int)((float)this.mTotalScrollY / this.mItemHeight);
        this.mCurrentIndex = this.mInitPosition + mChangingItem % this.mDataList.size();
        if (!this.mCanLoop) {
            if (this.mCurrentIndex < 0) {
                this.mCurrentIndex = 0;
            }
            if (this.mCurrentIndex > this.mDataList.size() - 1) {
                this.mCurrentIndex = this.mDataList.size() - 1;
            }
        } else {
            if (this.mCurrentIndex < 0) {
                this.mCurrentIndex = this.mDataList.size() + this.mCurrentIndex;
            }
            if (this.mCurrentIndex > this.mDataList.size() - 1) {
                this.mCurrentIndex -= this.mDataList.size();
            }
        }
        String[] itemCount = new String[this.mDrawItemsCount];
        for (count = 0; count < this.mDrawItemsCount; ++count) {
            int templateItem = this.mCurrentIndex - (this.mDrawItemsCount / 2 - count);
            if (this.mCanLoop) {
                if (templateItem < 0) {
                    templateItem += this.mDataList.size();
                }
                if (templateItem > this.mDataList.size() - 1) {
                    templateItem -= this.mDataList.size();
                }
                itemCount[count] = (String)this.mDataList.get(templateItem);
                continue;
            }
            itemCount[count] = templateItem < 0 ? "" : (templateItem > this.mDataList.size() - 1 ? "" : (String)this.mDataList.get(templateItem));
        }
        canvas.drawLine(0.0f, (float)this.mTopLineY, (float)this.mWidgetWidth, (float)this.mTopLineY, this.mCenterLinePaint);
        canvas.drawLine(0.0f, (float)this.mBottomLineY, (float)this.mWidgetWidth, (float)this.mBottomLineY, this.mCenterLinePaint);
        int changingLeftY = (int)((float)this.mTotalScrollY % this.mItemHeight);
        for (count = 0; count < this.mDrawItemsCount; ++count) {
            canvas.save();
            float itemHeight = (float)this.mMaxTextHeight * this.lineSpacingMultiplier;
            double radian = (itemHeight * (float)count - (float)changingLeftY) / (float)this.mCircularRadius;
            float angle = (float)(radian * 180.0 / Math.PI);
            if (angle >= 180.0f || angle <= 0.0f) {
                canvas.restore();
                continue;
            }
            int translateY = (int)((double)this.mCircularRadius - Math.cos(radian) * (double)this.mCircularRadius - Math.sin(radian) * (double)this.mMaxTextHeight / 2.0) + this.mPaddingTopBottom;
            canvas.translate(0.0f, (float)translateY);
            canvas.scale(1.0f, (float)Math.sin(radian));
            if (translateY <= this.mTopLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.mWidgetWidth, this.mTopLineY - translateY);
                canvas.drawText(itemCount[count], (float)this.mPaddingLeftRight, (float)this.mMaxTextHeight, this.mTopBottomTextPaint);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.mTopLineY - translateY, this.mWidgetWidth, (int)itemHeight);
                canvas.drawText(itemCount[count], (float)this.mPaddingLeftRight, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                canvas.restore();
            } else if (this.mMaxTextHeight + translateY >= this.mBottomLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.mWidgetWidth, this.mBottomLineY - translateY);
                canvas.drawText(itemCount[count], (float)this.mPaddingLeftRight, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.mBottomLineY - translateY, this.mWidgetWidth, (int)itemHeight);
                canvas.drawText(itemCount[count], (float)this.mPaddingLeftRight, (float)this.mMaxTextHeight, this.mTopBottomTextPaint);
                canvas.restore();
            } else if (translateY >= this.mTopLineY && this.mMaxTextHeight + translateY <= this.mBottomLineY) {
                canvas.clipRect(0, 0, this.mWidgetWidth, (int)itemHeight);
                canvas.drawText(itemCount[count], (float)this.mPaddingLeftRight, (float)this.mMaxTextHeight, this.mCenterTextPaint);
                this.mSelectedItem = this.mDataList.indexOf(itemCount[count]);
            }
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent motionevent) {
        switch (motionevent.getAction()) {
            default: 
        }
        if (!this.mGestureDetector.onTouchEvent(motionevent)) {
            this.startSmoothScrollTo();
        }
        return true;
    }

    public final void setCanLoop(boolean canLoop) {
        this.mCanLoop = canLoop;
        this.invalidate();
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.mTextSize = this.sp2px(this.mContext, size);
        }
    }

    public void setInitPosition(int initPosition) {
        this.mInitPosition = initPosition;
        this.invalidate();
    }

    public void setLoopListener(LoopScrollListener LoopListener) {
        this.mLoopListener = LoopListener;
    }

    public final void setDataList(List<String> list) {
        this.mDataList = (ArrayList)list;
        this.initData();
    }

    public int getSelectedItem() {
        return this.mSelectedItem;
    }

    private void itemSelected() {
        if (this.mLoopListener != null) {
            this.postDelayed(new SelectedRunnable(), 200L);
        }
    }

    private void cancelSchedule() {
        if (this.mScheduledFuture != null && !this.mScheduledFuture.isCancelled()) {
            this.mScheduledFuture.cancel(true);
            this.mScheduledFuture = null;
        }
    }

    private void startSmoothScrollTo() {
        int offset = (int)((float)this.mTotalScrollY % this.mItemHeight);
        this.cancelSchedule();
        this.mScheduledFuture = this.mExecutor.scheduleWithFixedDelay(new HalfHeightRunnable(offset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void startSmoothScrollTo(float velocityY) {
        this.cancelSchedule();
        int velocityFling = 20;
        this.mScheduledFuture = this.mExecutor.scheduleWithFixedDelay(new FlingRunnable(velocityY), 0L, velocityFling, TimeUnit.MILLISECONDS);
    }

    public int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    class FlingRunnable
    implements Runnable {
        float velocity;
        final float velocityY;

        FlingRunnable(float velocityY) {
            this.velocityY = velocityY;
            this.velocity = 2.1474836E9f;
        }

        @Override
        public void run() {
            if (this.velocity == 2.1474836E9f) {
                this.velocity = Math.abs(this.velocityY) > 2000.0f ? (this.velocityY > 0.0f ? 2000.0f : -2000.0f) : this.velocityY;
            }
            Log.i((String)TAG, (String)("velocity->" + this.velocity));
            if (Math.abs(this.velocity) >= 0.0f && Math.abs(this.velocity) <= 20.0f) {
                LoopView.this.cancelSchedule();
                LoopView.this.mHandler.sendEmptyMessage(2000);
                return;
            }
            int i = (int)(this.velocity * 10.0f / 1000.0f);
            LoopView.this.mTotalScrollY = LoopView.this.mTotalScrollY - i;
            if (!LoopView.this.mCanLoop) {
                float itemHeight = LoopView.this.lineSpacingMultiplier * (float)LoopView.this.mMaxTextHeight;
                if (LoopView.this.mTotalScrollY <= (int)((float)(-LoopView.this.mInitPosition) * itemHeight)) {
                    this.velocity = 40.0f;
                    LoopView.this.mTotalScrollY = (int)((float)(-LoopView.this.mInitPosition) * itemHeight);
                } else if (LoopView.this.mTotalScrollY >= (int)((float)(LoopView.this.mDataList.size() - 1 - LoopView.this.mInitPosition) * itemHeight)) {
                    LoopView.this.mTotalScrollY = (int)((float)(LoopView.this.mDataList.size() - 1 - LoopView.this.mInitPosition) * itemHeight);
                    this.velocity = -40.0f;
                }
            }
            this.velocity = this.velocity < 0.0f ? (this.velocity += 20.0f) : (this.velocity -= 20.0f);
            LoopView.this.mHandler.sendEmptyMessage(1000);
        }
    }

    class HalfHeightRunnable
    implements Runnable {
        int realTotalOffset;
        int realOffset;
        int offset;

        public HalfHeightRunnable(int offset) {
            this.offset = offset;
            this.realTotalOffset = Integer.MAX_VALUE;
            this.realOffset = 0;
        }

        @Override
        public void run() {
            if (this.realTotalOffset == Integer.MAX_VALUE) {
                this.realTotalOffset = (float)this.offset > LoopView.this.mItemHeight / 2.0f ? (int)(LoopView.this.mItemHeight - (float)this.offset) : -this.offset;
            }
            this.realOffset = (int)((float)this.realTotalOffset * 0.1f);
            if (this.realOffset == 0) {
                this.realOffset = this.realTotalOffset < 0 ? -1 : 1;
            }
            if (Math.abs(this.realTotalOffset) <= 0) {
                LoopView.this.cancelSchedule();
                LoopView.this.mHandler.sendEmptyMessage(3000);
                return;
            }
            LoopView.this.mTotalScrollY = LoopView.this.mTotalScrollY + this.realOffset;
            LoopView.this.mHandler.sendEmptyMessage(1000);
            this.realTotalOffset -= this.realOffset;
        }
    }

    class SelectedRunnable
    implements Runnable {
        SelectedRunnable() {
        }

        @Override
        public final void run() {
            LoopScrollListener listener = LoopView.this.mLoopListener;
            int selectedItem = LoopView.this.getSelectedItem();
            LoopView.this.mDataList.get(selectedItem);
            listener.onItemSelect(selectedItem);
        }
    }

    class LoopViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        LoopViewGestureListener() {
        }

        public final boolean onDown(MotionEvent motionevent) {
            LoopView.this.cancelSchedule();
            Log.i((String)TAG, (String)"LoopViewGestureListener->onDown");
            return true;
        }

        public final boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            LoopView.this.startSmoothScrollTo(velocityY);
            Log.i((String)TAG, (String)"LoopViewGestureListener->onFling");
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            Log.i((String)TAG, (String)"LoopViewGestureListener->onScroll");
            LoopView.this.mTotalScrollY = (int)((float)LoopView.this.mTotalScrollY + distanceY);
            if (!LoopView.this.mCanLoop) {
                int initPositionCircleLength = (int)((float)LoopView.this.mInitPosition * LoopView.this.mItemHeight);
                int initPositionStartY = -1 * initPositionCircleLength;
                if (LoopView.this.mTotalScrollY < initPositionStartY) {
                    LoopView.this.mTotalScrollY = initPositionStartY;
                }
                int circleLength = (int)((float)(LoopView.this.mDataList.size() - 1 - LoopView.this.mInitPosition) * LoopView.this.mItemHeight);
                if (LoopView.this.mTotalScrollY >= circleLength) {
                    LoopView.this.mTotalScrollY = circleLength;
                }
            }
            LoopView.this.invalidate();
            return true;
        }
    }
}

