/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.pickerview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.bruce.pickerview.LoopListener;
import com.bruce.pickerview.LoopRunnable;
import com.bruce.pickerview.LoopTimerTask;
import com.bruce.pickerview.LoopViewGestureListener;
import com.bruce.pickerview.MTimer;
import com.bruce.pickerview.MessageHandler;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LoopView
extends View {
    ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    int totalScrollY;
    Handler handler;
    LoopListener loopListener;
    private GestureDetector gestureDetector;
    private int selectedItem;
    private GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
    Context context;
    Paint paintA;
    Paint paintB;
    Paint paintC;
    ArrayList arrayList;
    int textSize;
    int maxTextWidth;
    int maxTextHeight;
    int colorGray;
    int colorBlack;
    int colorGrayLight;
    float lineSpacingMultiplier;
    boolean isLoop;
    int firstLineY;
    int secondLineY;
    int preCurrentIndex;
    int initPosition;
    int itemCount;
    int measuredHeight;
    int halfCircumference;
    int radius;
    int measuredWidth;
    int change;
    float y1;
    float y2;
    float dy;

    public LoopView(Context context) {
        super(context);
        this.initLoopView(context);
    }

    public LoopView(Context context, AttributeSet attributeset) {
        super(context, attributeset);
        this.initLoopView(context);
    }

    public LoopView(Context context, AttributeSet attributeset, int defStyleAttr) {
        super(context, attributeset, defStyleAttr);
        this.initLoopView(context);
    }

    private void initLoopView(Context context) {
        this.textSize = 0;
        this.colorGray = -5263441;
        this.colorBlack = -13553359;
        this.colorGrayLight = -3815995;
        this.lineSpacingMultiplier = 2.0f;
        this.isLoop = true;
        this.initPosition = -1;
        this.itemCount = 7;
        this.y1 = 0.0f;
        this.y2 = 0.0f;
        this.dy = 0.0f;
        this.totalScrollY = 0;
        this.simpleOnGestureListener = new LoopViewGestureListener(this);
        this.handler = new MessageHandler(this);
        this.context = context;
        this.setTextSize(16.0f);
        this.paintA = new Paint();
        this.paintB = new Paint();
        this.paintC = new Paint();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.simpleOnGestureListener);
        this.gestureDetector.setIsLongpressEnabled(false);
    }

    static int getSelectedItem(LoopView loopview) {
        return loopview.selectedItem;
    }

    static void smoothScroll(LoopView loopview) {
        loopview.smoothScroll();
    }

    private void initData() {
        if (this.arrayList == null) {
            return;
        }
        this.paintA.setColor(this.colorGray);
        this.paintA.setAntiAlias(true);
        this.paintA.setTypeface(Typeface.MONOSPACE);
        this.paintA.setTextSize((float)this.textSize);
        this.paintB.setColor(this.colorBlack);
        this.paintB.setAntiAlias(true);
        this.paintB.setTextScaleX(1.05f);
        this.paintB.setTypeface(Typeface.MONOSPACE);
        this.paintB.setTextSize((float)this.textSize);
        this.paintC.setColor(this.colorGrayLight);
        this.paintC.setAntiAlias(true);
        this.paintC.setTypeface(Typeface.MONOSPACE);
        this.paintC.setTextSize((float)this.textSize);
        this.measureTextWidthHeight();
        this.halfCircumference = (int)((float)this.maxTextHeight * this.lineSpacingMultiplier * (float)(this.itemCount - 1));
        this.measuredHeight = (int)((double)(this.halfCircumference * 2) / Math.PI);
        this.radius = (int)((double)this.halfCircumference / Math.PI);
        this.firstLineY = (int)(((float)this.measuredHeight - this.lineSpacingMultiplier * (float)this.maxTextHeight) / 2.0f);
        this.secondLineY = (int)(((float)this.measuredHeight + this.lineSpacingMultiplier * (float)this.maxTextHeight) / 2.0f);
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.arrayList.size() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.arrayList.size(); ++i) {
            String s1 = (String)this.arrayList.get(i);
            this.paintB.getTextBounds(s1, 0, s1.length(), rect);
            int textWidth = rect.width();
            if (textWidth > this.maxTextWidth) {
                this.maxTextWidth = textWidth;
            }
            this.paintB.getTextBounds("\u661f\u671f", 0, 2, rect);
            int textHeight = rect.height();
            if (textHeight <= this.maxTextHeight) continue;
            this.maxTextHeight = textHeight;
        }
    }

    private void smoothScroll() {
        int offset = (int)((float)this.totalScrollY % (this.lineSpacingMultiplier * (float)this.maxTextHeight));
        this.cancelFuture();
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new MTimer(this, offset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void cancelFuture() {
        if (this.mFuture != null && !this.mFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public final void setNotLoop() {
        this.isLoop = false;
    }

    public final void setTextSize(float size) {
        if (size > 0.0f) {
            this.textSize = (int)(this.context.getResources().getDisplayMetrics().density * size);
        }
    }

    public final void setInitPosition(int initPosition) {
        this.initPosition = initPosition;
    }

    public final void setListener(LoopListener LoopListener2) {
        this.loopListener = LoopListener2;
    }

    public final void setArrayList(ArrayList arraylist) {
        this.arrayList = arraylist;
        this.initData();
        this.invalidate();
    }

    public final int getSelectedItem() {
        return this.selectedItem;
    }

    protected final void smoothScroll(float velocityY) {
        this.cancelFuture();
        int velocityFling = 20;
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new LoopTimerTask(this, velocityY), 0L, velocityFling, TimeUnit.MILLISECONDS);
    }

    protected final void itemSelected() {
        if (this.loopListener != null) {
            this.postDelayed(new LoopRunnable(this), 200L);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.arrayList == null) {
            super.onDraw(canvas);
            return;
        }
        String[] as = new String[this.itemCount];
        this.change = (int)((float)this.totalScrollY / (this.lineSpacingMultiplier * (float)this.maxTextHeight));
        this.preCurrentIndex = this.initPosition + this.change % this.arrayList.size();
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.arrayList.size() - 1) {
                this.preCurrentIndex = this.arrayList.size() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.arrayList.size() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.arrayList.size() - 1) {
                this.preCurrentIndex -= this.arrayList.size();
            }
        }
        int j2 = (int)((float)this.totalScrollY % (this.lineSpacingMultiplier * (float)this.maxTextHeight));
        for (int k1 = 0; k1 < this.itemCount; ++k1) {
            int l1 = this.preCurrentIndex - (this.itemCount / 2 - k1);
            if (this.isLoop) {
                if (l1 < 0) {
                    l1 += this.arrayList.size();
                }
                if (l1 > this.arrayList.size() - 1) {
                    l1 -= this.arrayList.size();
                }
                as[k1] = (String)this.arrayList.get(l1);
                continue;
            }
            as[k1] = l1 < 0 ? "" : (l1 > this.arrayList.size() - 1 ? "" : (String)this.arrayList.get(l1));
        }
        int left = (this.measuredWidth - this.maxTextWidth) / 2;
        canvas.drawLine(0.0f, (float)this.firstLineY, (float)this.measuredWidth, (float)this.firstLineY, this.paintC);
        canvas.drawLine(0.0f, (float)this.secondLineY, (float)this.measuredWidth, (float)this.secondLineY, this.paintC);
        for (int j1 = 0; j1 < this.itemCount; ++j1) {
            canvas.save();
            float itemHeight = (float)this.maxTextHeight * this.lineSpacingMultiplier;
            double radian = (double)(itemHeight * (float)j1 - (float)j2) * Math.PI / (double)this.halfCircumference;
            float angle = (float)(90.0 - radian / Math.PI * 180.0);
            if (angle >= 90.0f || angle <= -90.0f) {
                canvas.restore();
                continue;
            }
            int translateY = (int)((double)this.radius - Math.cos(radian) * (double)this.radius - Math.sin(radian) * (double)this.maxTextHeight / 2.0);
            canvas.translate(0.0f, (float)translateY);
            canvas.scale(1.0f, (float)Math.sin(radian));
            if (translateY <= this.firstLineY && this.maxTextHeight + translateY >= this.firstLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, this.firstLineY - translateY);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintA);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.firstLineY - translateY, this.measuredWidth, (int)itemHeight);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintB);
                canvas.restore();
            } else if (translateY <= this.secondLineY && this.maxTextHeight + translateY >= this.secondLineY) {
                canvas.save();
                canvas.clipRect(0, 0, this.measuredWidth, this.secondLineY - translateY);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintB);
                canvas.restore();
                canvas.save();
                canvas.clipRect(0, this.secondLineY - translateY, this.measuredWidth, (int)itemHeight);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintA);
                canvas.restore();
            } else if (translateY >= this.firstLineY && this.maxTextHeight + translateY <= this.secondLineY) {
                canvas.clipRect(0, 0, this.measuredWidth, (int)itemHeight);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintB);
                this.selectedItem = this.arrayList.indexOf(as[j1]);
            } else {
                canvas.clipRect(0, 0, this.measuredWidth, (int)itemHeight);
                canvas.drawText(as[j1], (float)left, (float)this.maxTextHeight, this.paintA);
            }
            canvas.restore();
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initData();
        this.measuredWidth = this.getMeasuredWidth();
    }

    public boolean onTouchEvent(MotionEvent motionevent) {
        int circleLength;
        switch (motionevent.getAction()) {
            case 0: {
                this.y1 = motionevent.getRawY();
                break;
            }
            case 2: {
                int initPositionCircleLength;
                int initPositionStartY;
                this.y2 = motionevent.getRawY();
                this.dy = this.y1 - this.y2;
                this.y1 = this.y2;
                this.totalScrollY = (int)((float)this.totalScrollY + this.dy);
                if (this.isLoop || this.totalScrollY >= (initPositionStartY = -1 * (initPositionCircleLength = (int)((float)this.initPosition * (this.lineSpacingMultiplier * (float)this.maxTextHeight))))) break;
                this.totalScrollY = initPositionStartY;
                break;
            }
            default: {
                if (!this.gestureDetector.onTouchEvent(motionevent) && motionevent.getAction() == 1) {
                    this.smoothScroll();
                }
                return true;
            }
        }
        if (!this.isLoop && this.totalScrollY >= (circleLength = (int)((float)(this.arrayList.size() - 1 - this.initPosition) * (this.lineSpacingMultiplier * (float)this.maxTextHeight)))) {
            this.totalScrollY = circleLength;
        }
        this.invalidate();
        if (!this.gestureDetector.onTouchEvent(motionevent) && motionevent.getAction() == 1) {
            this.smoothScroll();
        }
        return true;
    }
}

