/*
 * Decompiled with CFR 0.152.
 */
package com.bruce.pickerview.popwindow;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.PopupWindow;
import com.bruce.pickerview.LoopListener;
import com.bruce.pickerview.LoopView;
import com.bruce.pickerview.R;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DatePickerPopWin
extends PopupWindow
implements View.OnClickListener {
    private static final int DEFAULT_MIN_YEAR = 1900;
    public Button cancelBtn;
    public Button confirmBtn;
    public LoopView yearLoopView;
    public LoopView monthLoopView;
    public LoopView dayLoopView;
    public View pickerContainerV;
    public View contentView;
    private int minYear;
    private int maxYear;
    private int yearPos = 0;
    private int monthPos = 0;
    private int dayPos = 0;
    private Context mContext;
    List<String> yearList = new ArrayList<String>();
    List<String> monthList = new ArrayList<String>();
    List<String> dayList = new ArrayList<String>();
    private OnDatePickedListener mListener;

    public DatePickerPopWin(Context cxt, String dataDesc, OnDatePickedListener l) {
        this(cxt, 1900, Calendar.getInstance().get(1), dataDesc, l);
    }

    public DatePickerPopWin(Context cxt, OnDatePickedListener l) {
        this(cxt, 1900, Calendar.getInstance().get(1), l);
    }

    public DatePickerPopWin(Context cxt, int minYear, int maxYear, String dataDesc, OnDatePickedListener l) {
        this.mContext = cxt;
        this.minYear = minYear;
        this.maxYear = maxYear;
        this.mListener = l;
        this.setSelectedDate(dataDesc);
        this.initView();
    }

    public DatePickerPopWin(Context cxt, int minYear, int maxYear, OnDatePickedListener l) {
        this.mContext = cxt;
        this.minYear = minYear;
        this.maxYear = maxYear;
        this.mListener = l;
        this.setSelectedDate(DatePickerPopWin.getStrDate());
        this.initView();
    }

    private void initView() {
        this.contentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_date_picker, null);
        this.cancelBtn = (Button)this.contentView.findViewById(R.id.btn_cancel);
        this.confirmBtn = (Button)this.contentView.findViewById(R.id.btn_confirm);
        this.yearLoopView = (LoopView)this.contentView.findViewById(R.id.picker_year);
        this.monthLoopView = (LoopView)this.contentView.findViewById(R.id.picker_month);
        this.dayLoopView = (LoopView)this.contentView.findViewById(R.id.picker_day);
        this.pickerContainerV = this.contentView.findViewById(R.id.container_picker);
        this.yearLoopView.setNotLoop();
        this.monthLoopView.setNotLoop();
        this.dayLoopView.setNotLoop();
        this.yearLoopView.setTextSize(25.0f);
        this.monthLoopView.setTextSize(25.0f);
        this.dayLoopView.setTextSize(25.0f);
        this.yearLoopView.setListener(new LoopListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.yearPos = item;
                DatePickerPopWin.this.initDayPickerView();
            }
        });
        this.monthLoopView.setListener(new LoopListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.monthPos = item;
                DatePickerPopWin.this.initDayPickerView();
            }
        });
        this.dayLoopView.setListener(new LoopListener(){

            @Override
            public void onItemSelect(int item) {
                DatePickerPopWin.this.dayPos = item;
            }
        });
        this.initPickerViews();
        this.initDayPickerView();
        this.cancelBtn.setOnClickListener((View.OnClickListener)this);
        this.confirmBtn.setOnClickListener((View.OnClickListener)this);
        this.contentView.setOnClickListener((View.OnClickListener)this);
        this.setTouchable(true);
        this.setFocusable(true);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.setAnimationStyle(R.style.FadeInPopWin);
        this.setContentView(this.contentView);
        this.setWidth(-1);
        this.setHeight(-1);
    }

    private void initPickerViews() {
        int yearCount = this.maxYear - this.minYear;
        for (int i = 0; i < yearCount; ++i) {
            this.yearList.add(DatePickerPopWin.format2LenStr(this.minYear + i));
        }
        for (int j = 0; j < 12; ++j) {
            this.monthList.add(DatePickerPopWin.format2LenStr(j + 1));
        }
        this.yearLoopView.setArrayList((ArrayList)this.yearList);
        this.yearLoopView.setInitPosition(this.yearPos);
        this.monthLoopView.setArrayList((ArrayList)this.monthList);
        this.monthLoopView.setInitPosition(this.monthPos);
    }

    private void initDayPickerView() {
        Calendar calendar = Calendar.getInstance();
        this.dayList = new ArrayList<String>();
        calendar.set(1, this.minYear + this.yearPos);
        calendar.set(2, this.monthPos);
        int dayMaxInMonth = calendar.getActualMaximum(5);
        for (int i = 0; i < dayMaxInMonth; ++i) {
            this.dayList.add(DatePickerPopWin.format2LenStr(i + 1));
        }
        this.dayLoopView.setArrayList((ArrayList)this.dayList);
        this.dayLoopView.setInitPosition(this.dayPos);
    }

    public void setSelectedDate(String dateStr) {
        if (!TextUtils.isEmpty((CharSequence)dateStr)) {
            long milliseconds = DatePickerPopWin.getLongFromyyyyMMdd(dateStr);
            Calendar calendar = Calendar.getInstance(Locale.CHINA);
            if (milliseconds != -1L) {
                calendar.setTimeInMillis(milliseconds);
                this.yearPos = calendar.get(1) - this.minYear;
                this.monthPos = calendar.get(2);
                this.dayPos = calendar.get(5) - 1;
            }
        }
    }

    public void showPopWin(Activity activity) {
        if (null != activity) {
            TranslateAnimation trans = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
            this.showAtLocation(activity.getWindow().getDecorView(), 80, 0, 0);
            trans.setDuration(400L);
            trans.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            this.pickerContainerV.startAnimation((Animation)trans);
        }
    }

    public void dismissPopWin() {
        TranslateAnimation trans = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        trans.setDuration(400L);
        trans.setInterpolator((Interpolator)new AccelerateInterpolator());
        trans.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                DatePickerPopWin.this.dismiss();
            }
        });
        this.pickerContainerV.startAnimation((Animation)trans);
    }

    public void onClick(View v) {
        if (v == this.contentView || v == this.cancelBtn) {
            this.dismissPopWin();
        } else if (v == this.confirmBtn) {
            if (null != this.mListener) {
                int year = this.minYear + this.yearPos;
                int month = this.monthPos + 1;
                int day = this.dayPos + 1;
                StringBuffer sb = new StringBuffer();
                sb.append(String.valueOf(year));
                sb.append("-");
                sb.append(DatePickerPopWin.format2LenStr(month));
                sb.append("-");
                sb.append(DatePickerPopWin.format2LenStr(day));
                this.mListener.onDatePickCompleted(year, month, day, sb.toString());
            }
            this.dismissPopWin();
        }
    }

    public static long getLongFromyyyyMMdd(String date) {
        SimpleDateFormat mFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Date parse = null;
        try {
            parse = mFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (parse != null) {
            return parse.getTime();
        }
        return -1L;
    }

    public static String getStrDate() {
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd");
        return dd.format(new Date());
    }

    public static String format2LenStr(int num) {
        return num < 10 ? "0" + num : String.valueOf(num);
    }

    public static interface OnDatePickedListener {
        public void onDatePickCompleted(int var1, int var2, int var3, String var4);
    }
}

