/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.littleshoot.proxy.impl.ProxyUtils;

public class WhitelistFilter
extends HttpsAwareFiltersAdapter {
    private final boolean whitelistEnabled;
    private final int whitelistResponseCode;
    private final Collection<Pattern> whitelistUrls;

    public WhitelistFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, boolean whitelistEnabled, int whitelistResponseCode, Collection<Pattern> whitelistUrls) {
        super(originalRequest, ctx);
        this.whitelistEnabled = whitelistEnabled;
        this.whitelistResponseCode = whitelistResponseCode;
        this.whitelistUrls = whitelistUrls != null ? whitelistUrls : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (!this.whitelistEnabled) {
            return null;
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
                return null;
            }
            String url = this.getFullUrl(httpRequest);
            boolean urlWhitelisted = this.whitelistUrls.stream().anyMatch(pattern -> pattern.matcher(url).matches());
            if (!urlWhitelisted) {
                HttpResponseStatus status = HttpResponseStatus.valueOf((int)this.whitelistResponseCode);
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(httpRequest.protocolVersion(), status);
                HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
                return resp;
            }
        }
        return null;
    }
}

