/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import com.browserup.bup.filters.ModifiedRequestAwareFilter;
import com.browserup.bup.filters.ResolvedHostnameCacheFilter;
import com.browserup.bup.filters.support.HttpConnectTiming;
import com.browserup.bup.filters.util.HarCaptureUtil;
import com.browserup.bup.util.BrowserUpProxyUtil;
import com.browserup.bup.util.HttpUtil;
import com.browserup.harreader.model.Har;
import com.browserup.harreader.model.HarEntry;
import com.browserup.harreader.model.HarRequest;
import com.browserup.harreader.model.HarResponse;
import com.browserup.harreader.model.HarTiming;
import com.browserup.harreader.model.HttpMethod;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectHarCaptureFilter
extends HttpsAwareFiltersAdapter
implements ModifiedRequestAwareFilter {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectHarCaptureFilter.class);
    private final Har har;
    private final String currentPageRef;
    private volatile Date requestStartTime;
    private volatile InetAddress resolvedAddress;
    private volatile long dnsResolutionStartedNanos;
    private volatile long dnsResolutionFinishedNanos;
    private volatile long connectionQueuedNanos;
    private volatile long connectionStartedNanos;
    private volatile long connectionSucceededTimeNanos;
    private volatile long sendStartedNanos;
    private volatile long sendFinishedNanos;
    private volatile long responseReceiveStartedNanos;
    private volatile long sslHandshakeStartedNanos;
    private final InetSocketAddress clientAddress;
    private final HttpConnectTiming httpConnectTiming;
    private static final int HTTP_CONNECT_TIMING_EVICTION_SECONDS = 60;
    private static final int HTTP_CONNECT_TIMING_CONCURRENCY_LEVEL = 50;
    private static final ConcurrentMap<InetSocketAddress, HttpConnectTiming> httpConnectTimes = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).concurrencyLevel(50).build().asMap();
    private volatile HttpRequest modifiedHttpRequest;

    public HttpConnectHarCaptureFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Har har, String currentPageRef) {
        super(originalRequest, ctx);
        if (har == null) {
            throw new IllegalStateException("Attempted har capture when har is null");
        }
        if (!ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
            throw new IllegalStateException("Attempted HTTP CONNECT har capture on non-HTTP CONNECT request");
        }
        this.har = har;
        this.currentPageRef = currentPageRef;
        this.clientAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        this.httpConnectTiming = new HttpConnectTiming();
        httpConnectTimes.put(this.clientAddress, this.httpConnectTiming);
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            this.requestStartTime = new Date();
        }
        return null;
    }

    public void proxyToServerResolutionFailed(String hostAndPort) {
        HarEntry harEntry = this.createHarEntryForFailedCONNECT(HarCaptureUtil.getResolutionFailedErrorMessage(hostAndPort));
        if (this.dnsResolutionStartedNanos > 0L) {
            harEntry.getTimings().setDns(System.nanoTime() - this.dnsResolutionStartedNanos, TimeUnit.NANOSECONDS);
        }
        harEntry.setTime(BrowserUpProxyUtil.getTotalElapsedTime(harEntry.getTimings()));
        this.har.getLog().getEntries().add(harEntry);
        httpConnectTimes.remove(this.clientAddress);
    }

    public void proxyToServerConnectionFailed() {
        HarEntry harEntry = this.createHarEntryForFailedCONNECT(HarCaptureUtil.getConnectionFailedErrorMessage());
        if (this.connectionStartedNanos > 0L) {
            harEntry.getTimings().setConnect(System.nanoTime() - this.connectionStartedNanos, TimeUnit.NANOSECONDS);
        }
        harEntry.setTime(BrowserUpProxyUtil.getTotalElapsedTime(harEntry.getTimings()));
        this.har.getLog().getEntries().add(harEntry);
        httpConnectTimes.remove(this.clientAddress);
    }

    public void proxyToServerConnectionSucceeded(ChannelHandlerContext serverCtx) {
        this.connectionSucceededTimeNanos = System.nanoTime();
        if (this.connectionStartedNanos > 0L) {
            this.httpConnectTiming.setConnectTimeNanos(this.connectionSucceededTimeNanos - this.connectionStartedNanos);
        } else {
            this.httpConnectTiming.setConnectTimeNanos(0L);
        }
        if (this.sslHandshakeStartedNanos > 0L) {
            this.httpConnectTiming.setSslHandshakeTimeNanos(this.connectionSucceededTimeNanos - this.sslHandshakeStartedNanos);
        } else {
            this.httpConnectTiming.setSslHandshakeTimeNanos(0L);
        }
    }

    public void proxyToServerConnectionSSLHandshakeStarted() {
        this.sslHandshakeStartedNanos = System.nanoTime();
    }

    public void serverToProxyResponseTimedOut() {
        HarEntry harEntry = this.createHarEntryForFailedCONNECT(HarCaptureUtil.getResponseTimedOutErrorMessage());
        long timeoutTimestampNanos = System.nanoTime();
        if (this.sendStartedNanos > 0L && this.sendFinishedNanos == 0L) {
            harEntry.getTimings().setSend(timeoutTimestampNanos - this.sendStartedNanos, TimeUnit.NANOSECONDS);
        } else if (this.sendFinishedNanos > 0L && this.responseReceiveStartedNanos == 0L) {
            harEntry.getTimings().setWait(timeoutTimestampNanos - this.sendFinishedNanos, TimeUnit.NANOSECONDS);
        } else if (this.responseReceiveStartedNanos > 0L) {
            harEntry.getTimings().setReceive(timeoutTimestampNanos - this.responseReceiveStartedNanos, TimeUnit.NANOSECONDS);
        }
        harEntry.setTime(BrowserUpProxyUtil.getTotalElapsedTime(harEntry.getTimings()));
        this.har.getLog().getEntries().add(harEntry);
    }

    public void proxyToServerConnectionQueued() {
        this.connectionQueuedNanos = System.nanoTime();
    }

    public InetSocketAddress proxyToServerResolutionStarted(String resolvingServerHostAndPort) {
        this.dnsResolutionStartedNanos = System.nanoTime();
        if (this.connectionQueuedNanos > 0L) {
            this.httpConnectTiming.setBlockedTimeNanos(this.dnsResolutionStartedNanos - this.connectionQueuedNanos);
        } else {
            this.httpConnectTiming.setBlockedTimeNanos(0L);
        }
        return null;
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        this.dnsResolutionFinishedNanos = System.nanoTime();
        if (this.dnsResolutionStartedNanos > 0L) {
            this.httpConnectTiming.setDnsTimeNanos(this.dnsResolutionFinishedNanos - this.dnsResolutionStartedNanos);
        } else {
            this.httpConnectTiming.setDnsTimeNanos(0L);
        }
        this.resolvedAddress = resolvedRemoteAddress.getAddress();
    }

    public void proxyToServerConnectionStarted() {
        this.connectionStartedNanos = System.nanoTime();
    }

    public void proxyToServerRequestSending() {
        this.sendStartedNanos = System.nanoTime();
    }

    public void proxyToServerRequestSent() {
        this.sendFinishedNanos = System.nanoTime();
    }

    public void serverToProxyResponseReceiving() {
        this.responseReceiveStartedNanos = System.nanoTime();
    }

    private void populateTimingsForFailedCONNECT(HarEntry harEntry) {
        HarTiming timings = harEntry.getTimings();
        if (this.connectionQueuedNanos > 0L && this.dnsResolutionStartedNanos > 0L) {
            timings.setBlocked(this.dnsResolutionStartedNanos - this.connectionQueuedNanos, TimeUnit.NANOSECONDS);
        }
        if (this.dnsResolutionStartedNanos > 0L && this.dnsResolutionFinishedNanos > 0L) {
            timings.setDns(this.dnsResolutionFinishedNanos - this.dnsResolutionStartedNanos, TimeUnit.NANOSECONDS);
        }
        if (this.connectionStartedNanos > 0L && this.connectionSucceededTimeNanos > 0L) {
            timings.setConnect(this.connectionSucceededTimeNanos - this.connectionStartedNanos, TimeUnit.NANOSECONDS);
            if (this.sslHandshakeStartedNanos > 0L) {
                timings.setSsl(this.connectionSucceededTimeNanos - this.sslHandshakeStartedNanos, TimeUnit.NANOSECONDS);
            }
        }
        if (this.sendStartedNanos > 0L && this.sendFinishedNanos >= 0L) {
            timings.setSend(this.sendFinishedNanos - this.sendStartedNanos, TimeUnit.NANOSECONDS);
        }
        if (this.sendFinishedNanos > 0L && this.responseReceiveStartedNanos >= 0L) {
            timings.setWait(this.responseReceiveStartedNanos - this.sendFinishedNanos, TimeUnit.NANOSECONDS);
        }
    }

    private HarEntry createHarEntryForFailedCONNECT(String errorMessage) {
        HarEntry harEntry = new HarEntry();
        harEntry.setPageref(this.currentPageRef);
        harEntry.setStartedDateTime(this.requestStartTime);
        HarRequest request = this.createRequestForFailedConnect(this.originalRequest);
        harEntry.setRequest(request);
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        response.setAdditionalField("_errorMessage", errorMessage);
        harEntry.setResponse(response);
        this.populateTimingsForFailedCONNECT(harEntry);
        this.populateServerIpAddress(harEntry);
        return harEntry;
    }

    private void populateServerIpAddress(HarEntry harEntry) {
        if (this.resolvedAddress != null) {
            harEntry.setServerIPAddress(this.resolvedAddress.getHostAddress());
        } else {
            String serverHost = HttpUtil.getHostFromRequest((HttpRequest)this.modifiedHttpRequest);
            if (serverHost != null && !serverHost.isEmpty()) {
                String resolvedAddress = ResolvedHostnameCacheFilter.getPreviouslyResolvedAddressForHost(serverHost);
                if (resolvedAddress != null) {
                    harEntry.setServerIPAddress(resolvedAddress);
                } else {
                    log.trace("Unable to find cached IP address for host: {}. IP address in HAR entry will be blank.", (Object)serverHost);
                }
            } else {
                log.warn("Unable to identify host from request uri: {}", (Object)this.modifiedHttpRequest.uri());
            }
        }
    }

    private HarRequest createRequestForFailedConnect(HttpRequest httpConnectRequest) {
        String url = this.getFullUrl(httpConnectRequest);
        HarRequest harRequest = new HarRequest();
        harRequest.setMethod(HttpMethod.valueOf(httpConnectRequest.method().toString()));
        harRequest.setUrl(url);
        harRequest.setHttpVersion(httpConnectRequest.protocolVersion().text());
        return harRequest;
    }

    public static HttpConnectTiming consumeConnectTimingForConnection(InetSocketAddress clientAddress) {
        return (HttpConnectTiming)httpConnectTimes.remove(clientAddress);
    }

    @Override
    public void setModifiedHttpRequest(HttpRequest modifiedHttpRequest) {
        this.modifiedHttpRequest = modifiedHttpRequest;
    }
}

