/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.kamikaze.docidset.impl.OrDocIdSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class AdaptiveFacetFilter
extends RandomAccessFilter {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AdaptiveFacetFilter.class);
    private final RandomAccessFilter _facetFilter;
    private final FacetDataCacheBuilder _facetDataCacheBuilder;
    private final Set<String> _valSet;
    private boolean _takeComplement = false;

    public AdaptiveFacetFilter(FacetDataCacheBuilder facetDataCacheBuilder, RandomAccessFilter facetFilter, String[] val, boolean takeComplement) {
        this._facetFilter = facetFilter;
        this._facetDataCacheBuilder = facetDataCacheBuilder;
        this._valSet = new HashSet<String>(Arrays.asList(val));
        this._takeComplement = takeComplement;
    }

    @Override
    public double getFacetSelectivity(BoboIndexReader reader) {
        double selectivity = this._facetFilter.getFacetSelectivity(reader);
        if (this._takeComplement) {
            return 1.0 - selectivity;
        }
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboIndexReader reader) throws IOException {
        int validFreqCount;
        RandomAccessDocIdSet innerDocSet = this._facetFilter.getRandomAccessDocIdSet(reader);
        if (innerDocSet == EmptyDocIdSet.getInstance()) {
            return innerDocSet;
        }
        FacetDataCache dataCache = this._facetDataCacheBuilder.build(reader);
        int totalCount = reader.maxDoc();
        TermValueList valArray = dataCache.valArray;
        int freqCount = 0;
        ArrayList<String> validVals = new ArrayList<String>(this._valSet.size());
        for (String val : this._valSet) {
            int idx = valArray.indexOf(val);
            if (idx < 0) continue;
            validVals.add(valArray.get(idx));
            freqCount += dataCache.freqs[idx];
        }
        if (validVals.size() == 0) {
            return EmptyDocIdSet.getInstance();
        }
        int n = validFreqCount = this._takeComplement ? totalCount - freqCount : freqCount;
        if (this._facetDataCacheBuilder.getIndexFieldName() != null && validFreqCount << 1 < totalCount) {
            return new TermListRandomAccessDocIdSet(this._facetDataCacheBuilder.getIndexFieldName(), innerDocSet, validVals, (IndexReader)reader);
        }
        return innerDocSet;
    }

    public static class TermListRandomAccessDocIdSet
    extends RandomAccessDocIdSet {
        private final RandomAccessDocIdSet _innerSet;
        private final ArrayList<String> _vals;
        private final IndexReader _reader;
        private final String _name;
        private static final int OR_THRESHOLD = 5;

        TermListRandomAccessDocIdSet(String name, RandomAccessDocIdSet innerSet, ArrayList<String> vals, IndexReader reader) {
            this._name = name;
            this._innerSet = innerSet;
            this._vals = vals;
            this._reader = reader;
        }

        @Override
        public boolean get(int docId) {
            return this._innerSet.get(docId);
        }

        public DocIdSetIterator iterator() throws IOException {
            if (this._vals.size() == 0) {
                return EmptyDocIdSet.getInstance().iterator();
            }
            if (this._vals.size() == 1) {
                return new TermDocIdSet(this._reader, this._name, this._vals.get(0)).iterator();
            }
            if (this._vals.size() < 5) {
                ArrayList<TermDocIdSet> docSetList = new ArrayList<TermDocIdSet>(this._vals.size());
                for (String val : this._vals) {
                    docSetList.add(new TermDocIdSet(this._reader, this._name, val));
                }
                return new OrDocIdSet(docSetList).iterator();
            }
            return this._innerSet.iterator();
        }

        public static class TermDocIdSet
        extends DocIdSet {
            final Term term;
            private final IndexReader reader;

            public TermDocIdSet(IndexReader reader, String name, String val) {
                this.reader = reader;
                this.term = new Term(name, val);
            }

            public DocIdSetIterator iterator() throws IOException {
                final TermDocs td = this.reader.termDocs(this.term);
                if (td == null) {
                    return EmptyDocIdSet.getInstance().iterator();
                }
                return new DocIdSetIterator(){
                    private int _doc = -1;

                    public int advance(int target) throws IOException {
                        if (td.skipTo(target)) {
                            this._doc = td.doc();
                        } else {
                            td.close();
                            this._doc = Integer.MAX_VALUE;
                        }
                        return this._doc;
                    }

                    public int docID() {
                        return this._doc;
                    }

                    public int nextDoc() throws IOException {
                        if (td.next()) {
                            this._doc = td.doc();
                        } else {
                            td.close();
                            this._doc = Integer.MAX_VALUE;
                        }
                        return this._doc;
                    }
                };
            }
        }
    }

    public static interface FacetDataCacheBuilder {
        public FacetDataCache build(BoboIndexReader var1);

        public String getName();

        public String getIndexFieldName();
    }
}

