/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermLongList;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TermDateList
extends TermLongList {
    private ThreadLocal<SimpleDateFormat> _dateFormatter = null;

    public TermDateList(String formatString) {
        this.setFormatString(formatString);
    }

    public TermDateList(int capacity, String formatString) {
        super(capacity, formatString);
        this.setFormatString(formatString);
    }

    @Override
    public String getFormatString() {
        return this._formatString;
    }

    @Override
    protected void setFormatString(final String formatString) {
        this._formatString = formatString;
        this._dateFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                if (formatString != null) {
                    return new SimpleDateFormat(formatString);
                }
                return null;
            }
        };
    }

    @Override
    protected long parse(String o) {
        if (o == null || o.length() == 0) {
            return 0L;
        }
        try {
            return this._dateFormatter.get().parse(o).getTime();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe.getMessage(), pe);
        }
    }

    @Override
    public String get(int index) {
        SimpleDateFormat formatter = this._dateFormatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    @Override
    public String format(Object o) {
        Long val = o instanceof String ? Long.valueOf(this.parse((String)o)) : (Long)o;
        if (this._formatter == null) {
            return String.valueOf(o);
        }
        SimpleDateFormat formatter = this._dateFormatter.get();
        if (formatter == null) {
            return String.valueOf(o);
        }
        return ((DecimalFormat)this._formatter.get()).format(new Date(val));
    }
}

