/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.client;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.FacetAccessible;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrowseResultFormatter {
    static String formatResults(BrowseResult res) {
        StringBuffer sb = new StringBuffer();
        sb.append(res.getNumHits());
        sb.append(" hits out of ");
        sb.append(res.getTotalDocs());
        sb.append(" docs\n");
        BrowseHit[] hits = res.getHits();
        Map<String, FacetAccessible> map = res.getFacetMap();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            FacetAccessible fa = map.get(key);
            sb.append(key + "\n");
            List<BrowseFacet> lf = fa.getFacets();
            for (BrowseFacet bf : lf) {
                sb.append("\t" + bf + "\n");
            }
        }
        for (BrowseHit hit : hits) {
            sb.append("------------\n");
            sb.append(BrowseResultFormatter.formatHit(hit));
            sb.append("\n");
        }
        sb.append("*****************************\n");
        return sb.toString();
    }

    static StringBuffer formatHit(BrowseHit hit) {
        StringBuffer sb = new StringBuffer();
        Map<String, String[]> fields = hit.getFieldValues();
        Set<String> keys = fields.keySet();
        for (String key : keys) {
            String[] values;
            sb.append("\t" + key + " :");
            for (String value : values = fields.get(key)) {
                sb.append(" " + value);
            }
            sb.append("\n");
        }
        return sb;
    }
}

