/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Run
implements Serializable {
    private Map<Scenario, ScenarioResult> measurements;
    private String benchmarkName;
    private long executedTimestamp;

    public Run(Map<Scenario, ScenarioResult> measurements, String benchmarkName, Date executedTimestamp) {
        if (benchmarkName == null || executedTimestamp == null) {
            throw new NullPointerException();
        }
        this.measurements = new LinkedHashMap<Scenario, ScenarioResult>(measurements);
        this.benchmarkName = benchmarkName;
        this.executedTimestamp = executedTimestamp.getTime();
    }

    public Map<Scenario, ScenarioResult> getMeasurements() {
        return this.measurements;
    }

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public Date getExecutedTimestamp() {
        return new Date(this.executedTimestamp);
    }

    public boolean equals(Object o) {
        if (o instanceof Run) {
            Run that = (Run)o;
            return this.measurements.equals(that.measurements) && this.benchmarkName.equals(that.benchmarkName) && this.executedTimestamp == that.executedTimestamp;
        }
        return false;
    }

    public int hashCode() {
        int result = this.measurements.hashCode();
        result = result * 37 + this.benchmarkName.hashCode();
        result = result * 37 + (int)(this.executedTimestamp >> 32 ^ this.executedTimestamp);
        return result;
    }

    public String toString() {
        return this.measurements.toString();
    }

    private Run() {
    }
}

