/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Measurement
implements Serializable {
    public static final Comparator<Measurement> SORT_BY_NANOS = new Comparator<Measurement>(){

        @Override
        public int compare(Measurement a, Measurement b) {
            double aNanos = a.getRaw();
            double bNanos = b.getRaw();
            return Double.compare(aNanos, bNanos);
        }
    };
    public static final Comparator<Measurement> SORT_BY_UNITS = new Comparator<Measurement>(){

        @Override
        public int compare(Measurement a, Measurement b) {
            double aNanos = a.getProcessed();
            double bNanos = b.getProcessed();
            return Double.compare(aNanos, bNanos);
        }
    };
    private double raw;
    private double processed;
    private Map<String, Integer> unitNames;

    public Measurement(Map<String, Integer> unitNames, double raw, double processed) {
        this.unitNames = new HashMap<String, Integer>(unitNames);
        this.raw = raw;
        this.processed = processed;
    }

    public Map<String, Integer> getUnitNames() {
        return new HashMap<String, Integer>(this.unitNames);
    }

    public double getRaw() {
        return this.raw;
    }

    public double getProcessed() {
        return this.processed;
    }

    public boolean equals(Object o) {
        return o instanceof Measurement && ((Measurement)o).raw == this.raw && ((Measurement)o).processed == this.processed && ((Measurement)o).unitNames.equals(this.unitNames);
    }

    public int hashCode() {
        return (int)this.raw + (int)this.processed * 37 + this.unitNames.hashCode() * 1373;
    }

    public String toString() {
        return this.raw != this.processed ? this.raw + "/" + this.processed : Double.toString(this.raw);
    }

    private Measurement() {
    }
}

