/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.brianfromoregon.CaliperBuildAction;
import com.brianfromoregon.ScenarioKey;
import com.brianfromoregon.Stats;
import com.brianfromoregon.SubSecond;
import com.google.caliper.MeasurementType;
import com.google.caliper.ScenarioResult;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;

public class ScenarioTrend {
    public final int id;
    public final AbstractBuild<?, ?> build;
    public final ScenarioKey scenarioKey;

    protected ScenarioTrend(ScenarioKey scenarioKey, AbstractBuild<?, ?> build, int id) {
        this.scenarioKey = scenarioKey;
        this.build = build;
        this.id = id;
    }

    public String getBenchmarkName() {
        return this.scenarioKey.getBenchmarkName();
    }

    public Map<String, String> getParameters() {
        return this.scenarioKey.getScenario().getVariables();
    }

    private Iterable<BuildTimingResult> allResults() {
        ArrayList results = Lists.newArrayList();
        for (AbstractBuild build = this.build; build != null; build = (AbstractBuild)build.getPreviousBuiltBuild()) {
            ScenarioResult result;
            CaliperBuildAction buildAction = (CaliperBuildAction)build.getAction(CaliperBuildAction.class);
            if (buildAction == null || (result = buildAction.getResults().getScenarios().get(this.scenarioKey)) == null) continue;
            results.add(new BuildTimingResult(result.getMeasurementSet(MeasurementType.TIME).meanRaw(), build));
        }
        return results;
    }

    private SubSecond finestUnit() {
        return SubSecond.finestFor(Iterables.transform(this.allResults(), (Function)new Function<BuildTimingResult, Double>(){

            public Double apply(BuildTimingResult buildTimingResult) {
                return buildTimingResult.nanos;
            }
        }));
    }

    public Graph createGraph() {
        return new Graph(-1L, 500, 150){

            protected JFreeChart createGraph() {
                DataSetBuilder dataSet = new DataSetBuilder();
                SubSecond finest = ScenarioTrend.this.finestUnit();
                for (BuildTimingResult result : ScenarioTrend.this.allResults()) {
                    ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(result.build);
                    dataSet.add((Number)finest.fromNanos(result.nanos), (Comparable)((Object)finest.name), (Comparable)label);
                }
                JFreeChart chart = ChartFactory.createLineChart(null, null, (String)finest.name, (CategoryDataset)dataSet.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                LineAndShapeRenderer r = (LineAndShapeRenderer)chart.getCategoryPlot().getRenderer();
                r.setSeriesShape(0, (Shape)new Rectangle(-2, -2, 4, 4));
                r.setSeriesShapesVisible(0, true);
                r.setSeriesShapesFilled(0, true);
                return chart;
            }
        };
    }

    public Stats getStatistics() {
        SubSecond finest = this.finestUnit();
        Stats stats = new Stats(finest);
        for (BuildTimingResult result : this.allResults()) {
            stats.addValue(result.nanos);
        }
        return stats;
    }

    private static class BuildTimingResult {
        public final AbstractBuild<?, ?> build;
        public final double nanos;

        BuildTimingResult(double nanos, AbstractBuild<?, ?> build) {
            this.nanos = nanos;
            this.build = build;
        }
    }
}

