/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.brianfromoregon.ScenarioKey;
import com.brianfromoregon.SubSecond;
import com.google.caliper.MeasurementSet;
import com.google.caliper.MeasurementType;
import com.google.caliper.ScenarioResult;
import java.text.DecimalFormat;
import java.util.Map;

public class ScenarioResultChange {
    private final ScenarioKey scenarioKey;
    private final MeasurementSet oldBytes;
    private final MeasurementSet oldInstances;
    private final MeasurementSet oldTime;
    private final MeasurementSet newBytes;
    private final MeasurementSet newInstances;
    private final MeasurementSet newTime;

    public ScenarioResultChange(ScenarioKey scenarioKey, ScenarioResult old, ScenarioResult nu) {
        this.scenarioKey = scenarioKey;
        if (old != null) {
            this.oldBytes = old.getMeasurementSet(MeasurementType.MEMORY);
            this.oldInstances = old.getMeasurementSet(MeasurementType.INSTANCE);
            this.oldTime = old.getMeasurementSet(MeasurementType.TIME);
        } else {
            this.oldTime = null;
            this.oldInstances = null;
            this.oldBytes = null;
        }
        if (nu != null) {
            this.newBytes = nu.getMeasurementSet(MeasurementType.MEMORY);
            this.newInstances = nu.getMeasurementSet(MeasurementType.INSTANCE);
            this.newTime = nu.getMeasurementSet(MeasurementType.TIME);
        } else {
            this.newTime = null;
            this.newInstances = null;
            this.newBytes = null;
        }
    }

    public Integer getNewBytes() {
        if (this.newBytes == null) {
            return null;
        }
        return (int)this.newBytes.meanRaw();
    }

    public Integer getNewInstances() {
        if (this.newInstances == null) {
            return null;
        }
        return (int)this.newInstances.meanRaw();
    }

    public Double getNewNanos() {
        if (this.newTime == null) {
            return null;
        }
        return this.newTime.meanRaw();
    }

    public Integer getOldBytes() {
        if (this.oldBytes == null) {
            return null;
        }
        return (int)this.oldBytes.meanRaw();
    }

    public Integer getOldInstances() {
        if (this.oldInstances == null) {
            return null;
        }
        return (int)this.oldInstances.meanRaw();
    }

    public Double getOldNanos() {
        if (this.oldTime == null) {
            return null;
        }
        return this.oldTime.meanRaw();
    }

    public Type getBytesType() {
        return this.getType(this.getNewBytes(), this.getOldBytes());
    }

    public Type getInstancesType() {
        return this.getType(this.getNewInstances(), this.getOldInstances());
    }

    public Type getTimeType() {
        return this.getType(this.getNewNanos(), this.getOldNanos());
    }

    private Type getType(Number nu, Number old) {
        double dold;
        if (nu == null) {
            return Type.NO_RESULT;
        }
        if (old == null) {
            return Type.NEW_RESULT;
        }
        double dnu = nu.doubleValue();
        if (Math.abs(dnu - (dold = old.doubleValue())) < 1.0) {
            return Type.SAME;
        }
        if (dnu > dold) {
            return Type.WORSE;
        }
        if (dnu < dold) {
            return Type.BETTER;
        }
        return Type.SAME;
    }

    public String getBytesString() {
        switch (this.getBytesType()) {
            case NO_RESULT: {
                return "";
            }
            case NEW_RESULT: 
            case SAME: {
                return this.getNewBytes().toString();
            }
        }
        return this.getNewBytes() + " (was " + this.getOldBytes() + ")";
    }

    public String getInstancesString() {
        switch (this.getInstancesType()) {
            case NO_RESULT: {
                return "";
            }
            case NEW_RESULT: 
            case SAME: {
                return this.getNewInstances().toString();
            }
        }
        return this.getNewInstances() + " (was " + this.getOldInstances() + ")";
    }

    public String getTimeString() {
        switch (this.getTimeType()) {
            case NO_RESULT: {
                return "";
            }
            case NEW_RESULT: 
            case SAME: {
                return SubSecond.finestFor(this.getNewNanos()).format(this.getNewNanos());
            }
        }
        double pct = this.getNewNanos() / this.getOldNanos() - 1.0;
        String direction = pct > 0.0 ? "up" : "down";
        return String.format("%s (%s %s%%)", SubSecond.finestFor(this.getNewNanos()).format(this.getNewNanos()), direction, new DecimalFormat("0.0").format(Math.abs(pct) * 100.0));
    }

    public String getBenchmarkName() {
        return this.scenarioKey.getBenchmarkName();
    }

    public Map<String, String> getScenario() {
        return this.scenarioKey.getScenario().getVariables();
    }

    public static enum Type {
        BETTER,
        WORSE,
        SAME,
        NEW_RESULT,
        NO_RESULT;

    }
}

