/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.brianfromoregon.CaliperBuildAction;
import com.brianfromoregon.ParsedFile;
import com.brianfromoregon.ResultUploader;
import com.google.caliper.Json;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import com.google.gson.JsonParseException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class CaliperResultsRecorder
extends Recorder {
    private static final Logger LOGGER = Logger.getLogger(CaliperResultsRecorder.class.getName());
    public final String results;
    public final String postUrl;
    public final String apiKey;
    public final String proxyHostPort;

    @DataBoundConstructor
    public CaliperResultsRecorder(String results, String postUrl, String apiKey, String proxyHostPort) {
        this.results = results.trim();
        this.postUrl = postUrl.trim();
        this.apiKey = apiKey.trim();
        this.proxyHostPort = proxyHostPort.trim();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Recording Caliper results: " + this.results);
        List<ParsedFile> jsonResults = this.readUtf8Results(build);
        if (jsonResults.size() == 0) {
            listener.error("No matching file found. Configuration error?");
            return false;
        }
        ArrayList<com.google.caliper.Result> results = new ArrayList<com.google.caliper.Result>();
        Iterator<ParsedFile> it = jsonResults.iterator();
        while (it.hasNext()) {
            ParsedFile f = it.next();
            try {
                com.google.caliper.Result result = (com.google.caliper.Result)Json.getGsonInstance().fromJson(f.content, com.google.caliper.Result.class);
                if (result == null || result.getRun() == null) {
                    listener.getLogger().println("JSON does not convert to a Result, skipping: " + f.name);
                    it.remove();
                    continue;
                }
                results.add(result);
            }
            catch (JsonParseException e) {
                listener.getLogger().println("Could not parse file as JSON (see logs for details), skipping: " + f.name);
                LOGGER.log(Level.WARNING, "Could not parse file as JSON, skipping: " + f.name, e);
                it.remove();
            }
        }
        if (results.size() == 0) {
            listener.error("No useful result files kept. Configuration error?");
            return false;
        }
        this.addBuildAction(build, listener, Lists.transform(jsonResults, (Function)new Function<ParsedFile, String>(){

            public String apply(ParsedFile input) {
                return input.content;
            }
        }));
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    List<ParsedFile> readUtf8Results(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        ArrayList readFiles = Lists.newArrayList();
        for (FilePath f : build.getWorkspace().list(this.results)) {
            readFiles.add(new ParsedFile(f.getName(), CharStreams.toString((Readable)new InputStreamReader(f.read(), Charsets.UTF_8))));
        }
        return readFiles;
    }

    void addBuildAction(AbstractBuild<?, ?> build, BuildListener listener, List<String> jsonResults) {
        CaliperBuildAction action = new CaliperBuildAction(jsonResults.toArray(new String[jsonResults.size()]), build);
        build.addAction((Action)action);
        if (!this.postUrl.isEmpty() && !this.apiKey.isEmpty()) {
            ResultUploader uploader = new ResultUploader();
            for (com.google.caliper.Result result : action.jsonToResults()) {
                listener.getLogger().printf("Uploading result for benchmark '%s' to '%s'\n", result.getRun().getBenchmarkName(), this.postUrl);
                listener.getLogger().println("Outcome: " + uploader.postResults(result, this.postUrl, this.apiKey, this.proxyHostPort));
            }
        }
        if (action.getResultDifference().getNumMemoryRegressions() > 0) {
            build.setResult(Result.UNSTABLE);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish Caliper microbenchmark results";
        }
    }
}

