/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.brianfromoregon.BuildResults;
import com.brianfromoregon.ScenarioKey;
import com.brianfromoregon.ScenarioResultChange;
import com.google.caliper.ScenarioResult;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Map;

public class BuildResultDifference {
    public final ImmutableList<ScenarioResultChange> changes;

    public BuildResultDifference(BuildResults old, BuildResults nu) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<ScenarioKey, ScenarioResult> entry : nu.getScenarios().entrySet()) {
            ScenarioResult oldResult = null;
            if (old != null) {
                oldResult = old.getScenarios().get(entry.getKey());
            }
            builder.add((Object)new ScenarioResultChange(entry.getKey(), oldResult, entry.getValue()));
        }
        this.changes = builder.build();
    }

    public int getNumMemoryResults() {
        return Iterables.size((Iterable)Iterables.filter(this.changes, (Predicate)new Predicate<ScenarioResultChange>(){

            public boolean apply(ScenarioResultChange input) {
                return input.getBytesType() != ScenarioResultChange.Type.NO_RESULT || input.getInstancesType() != ScenarioResultChange.Type.NO_RESULT;
            }
        }));
    }

    public int getNumTimingResults() {
        return Iterables.size((Iterable)Iterables.filter(this.changes, (Predicate)new Predicate<ScenarioResultChange>(){

            public boolean apply(ScenarioResultChange input) {
                return input.getTimeType() != ScenarioResultChange.Type.NO_RESULT;
            }
        }));
    }

    public int getNumMemoryRegressions() {
        return Iterables.size((Iterable)Iterables.filter(this.changes, (Predicate)new Predicate<ScenarioResultChange>(){

            public boolean apply(ScenarioResultChange input) {
                return input.getBytesType() == ScenarioResultChange.Type.WORSE || input.getInstancesType() == ScenarioResultChange.Type.WORSE;
            }
        }));
    }
}

