/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.util.Mutator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public enum TypeHandler {
    STRING(String.class, null, "%1$s::%2$s"),
    INTEGER(Integer.TYPE, Integer.class, null, "( %1$s, text ) -> %1$s.%2$s( Integer.parseInt( text ) )"),
    FLOAT(Float.TYPE, Float.class, null, "( %1$s, text ) -> %1$s.%2$s( Float.parseFloat( text ) )"),
    DOUBLE(Double.TYPE, Double.class, null, "( %1$s, text ) -> %1$s.%2$s( Double.parseDouble( text ) )"),
    LONG(Long.TYPE, Long.class, null, "( %1$s, text ) -> %1$s.%2$s( Long.parseLong( text ) )"),
    SHORT(Short.TYPE, Short.class, null, "( %1$s, text ) -> %1$s.%2$s( Short.parseShort( text ) )"),
    BOOLEAN(Boolean.TYPE, Boolean.class, null, "( %1$s, text ) -> %1$s.%2$s( Boolean.parseBoolean( text ) )"),
    BYTE(Byte.TYPE, Byte.class, null, "( %1$s, text ) -> %1$s.%2$s( Byte.parseByte( text ) )"),
    CHAR(Character.TYPE, Character.class, null, "( %1$s, text ) -> %1$s.%2$s( Char.parseChar( text ) )"),
    LIST(List.class, "%1$s.%2$s( new ArrayList<>() )", null),
    PROPERTIES(Properties.class, "%1$s.%2$s( new Properties() )", null),
    MAP(Map.class, "%1$s.%2$s( new HashMap<>() )", null),
    ENUM(Enum.class, null, "( %1$s, text ) -> %1$s.%2$s( %3$s.valueOf( text ) )");

    private final Class<?> clazz;
    private final Class<?> clazzBoxed;
    private final String opener;
    private final String closer;

    private TypeHandler(Class<?> clazz, String opener, String closer) {
        this(clazz, clazz, opener, closer);
    }

    private TypeHandler(Class<?> clazz, Class<?> clazzBoxed, String opener, String closer) {
        this.clazz = clazz;
        this.clazzBoxed = clazzBoxed;
        this.opener = opener;
        this.closer = closer;
    }

    public static TypeHandler identify(Class<?> clazz) {
        return Arrays.stream(TypeHandler.values()).filter(th -> th.clazz.isAssignableFrom(clazz) || th.clazzBoxed.isAssignableFrom(clazz)).findAny().orElse(null);
    }

    public String getOpener(Mutator mutator) {
        return this.renderMutator(mutator, this.opener);
    }

    public String getCloser(Mutator mutator) {
        return this.renderMutator(mutator, this.closer);
    }

    private String renderMutator(Mutator mutator, String formatter) {
        switch (this) {
            case STRING: {
                return Optional.ofNullable(formatter).map(op -> String.format(formatter, mutator.getContext().getSimpleName(), mutator.getName())).orElse(null);
            }
            case INTEGER: 
            case LONG: 
            case SHORT: 
            case BYTE: 
            case DOUBLE: 
            case FLOAT: 
            case CHAR: {
                return Optional.ofNullable(formatter).map(op -> String.format(formatter, mutator.getContext().getSimpleName().toLowerCase(), mutator.getName())).orElse(null);
            }
            case LIST: 
            case PROPERTIES: 
            case MAP: {
                return Optional.ofNullable(formatter).map(op -> String.format(formatter, mutator.getContext().getSimpleName().toLowerCase(), mutator.getName(), mutator.getContextStep().getSimpleName())).orElse(null);
            }
        }
        return mutator.isChildOfCollectionOrMap() ? (String)Optional.ofNullable(formatter).map(op -> String.format(formatter, mutator.getParent().getContextStep().getSimpleName().toLowerCase(), mutator.getName(), mutator.getParent().getArgumentType().getSimpleName())).orElse(null) : (String)Optional.ofNullable(formatter).map(op -> String.format(formatter, mutator.getContextStep().getSimpleName().toLowerCase(), mutator.getName(), mutator.getContextStep().getSimpleName().toLowerCase())).orElse(null);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?> getClazzBoxed() {
        return this.clazzBoxed;
    }

    public String getOpener() {
        return this.opener;
    }

    public String getCloser() {
        return this.closer;
    }
}

