/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.Materializer;
import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.model.Closer;
import com.brentcroft.tools.materializer.model.FlatTag;
import com.brentcroft.tools.materializer.model.Opener;
import com.brentcroft.tools.materializer.util.SchemaObject;
import com.brentcroft.tools.materializer.util.SchemaReferenceTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.xml.sax.InputSource;

public enum SchemaRootTag implements FlatTag<SchemaObject>
{
    ANYTHING("*", new Tag[0]){

        @Override
        public Tag<? super SchemaObject, ?>[] getChildren() {
            return Tag.tags(ANYTHING);
        }
    }
    ,
    IMPORT("import", (schemaObject, event) -> event){

        @Override
        public Closer<SchemaObject, SchemaObject, String, OpenEvent> getCloser() {
            return (context, schemaObject, text, event) -> {
                File currentLocus = new File(schemaObject.getSystemId());
                String systemId = String.format("%s/%s", currentLocus.getParent(), event.getAttribute("schemaLocation"));
                Materializer<SchemaObject> materializer = new Materializer<SchemaObject>(() -> ROOT, () -> {
                    SchemaObject so = new SchemaObject();
                    so.setSystemId(systemId);
                    return so;
                });
                try {
                    SchemaObject importedSchemaObject = materializer.apply(new InputSource(new FileInputStream(systemId)));
                    importedSchemaObject.reify();
                    schemaObject.getRootObjects().addAll(importedSchemaObject.getRootObjects());
                    schemaObject.getComplexTypes().addAll(importedSchemaObject.getComplexTypes());
                    schemaObject.getSimpleTypes().addAll(importedSchemaObject.getSimpleTypes());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
    ,
    ATTRIBUTE("attribute", ANYTHING),
    ATTRIBUTEGROUP("attributeGroup", ANYTHING),
    SCHEMA("schema", (schemaObject, event) -> {
        event.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k.toString().startsWith("xmlns:")) {
                String prefix = k.toString().substring(6);
                schemaObject.getNamespacePrefixes().put(prefix, v.toString());
                if ("http://www.w3.org/2001/XMLSchema".equals(v)) {
                    schemaObject.setXsdPrefix(prefix);
                }
            }
        }));
        Optional.ofNullable(event.getAttribute("targetNamespace", false)).flatMap(targetNamespace -> schemaObject.getNamespacePrefixes().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(targetNamespace)).findAny().map(Map.Entry::getKey)).ifPresent(schemaObject::setLocalPrefix);
    }, IMPORT, SchemaReferenceTag.ELEMENT, SchemaReferenceTag.COMPLEX_TYPE, SchemaReferenceTag.SIMPLE_TYPE, ATTRIBUTE, ATTRIBUTEGROUP),
    ROOT("", SCHEMA);

    private final String tag;
    private final boolean multiple = true;
    private final boolean choice = true;
    private final Opener<SchemaObject, SchemaObject, OpenEvent, ?> opener;
    private final Tag<? super SchemaObject, ?>[] children;

    @SafeVarargs
    private SchemaRootTag(String tag, Tag<? super SchemaObject, ?> ... children) {
        this.tag = tag;
        this.opener = null;
        this.children = children;
    }

    @SafeVarargs
    private SchemaRootTag(String tag, BiConsumer<SchemaObject, OpenEvent> opener, Tag<? super SchemaObject, ?> ... children) {
        this.tag = tag;
        this.opener = Opener.flatOpener(opener);
        this.children = children;
    }

    private <T> SchemaRootTag(String tag, BiFunction<SchemaObject, OpenEvent, T> opener) {
        this.tag = tag;
        this.opener = Opener.flatCacheOpener(opener);
        this.children = Tag.tags(new Tag[0]);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isMultiple() {
        this.getClass();
        return true;
    }

    @Override
    public boolean isChoice() {
        this.getClass();
        return true;
    }

    @Override
    public Opener<SchemaObject, SchemaObject, OpenEvent, ?> getOpener() {
        return this.opener;
    }

    @Override
    public Tag<? super SchemaObject, ?>[] getChildren() {
        return this.children;
    }
}

