/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TriConsumer;
import com.brentcroft.tools.materializer.model.Opener;
import com.brentcroft.tools.materializer.model.StepOpener;
import com.brentcroft.tools.materializer.model.StepTag;
import com.brentcroft.tools.materializer.util.ComplexTypeObject;
import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.SchemaItem;
import com.brentcroft.tools.materializer.util.SchemaLeafTag;
import com.brentcroft.tools.materializer.util.SchemaObject;
import com.brentcroft.tools.materializer.util.SimpleTypeObject;

enum SchemaReferenceTag implements StepTag<SchemaObject, SchemaItem>
{
    ELEMENT("element", (schema, item, event) -> item.setAttributes(event.asStringMap()), new Tag[]{SchemaLeafTag.COMPLEX_TYPE, SchemaLeafTag.SIMPLE_TYPE, SchemaLeafTag.ANNOTATION}){

        @Override
        public ElementObject getItem(SchemaObject schemaObject, OpenEvent event) {
            ElementObject item = new ElementObject(null);
            schemaObject.getRootObjects().add(item);
            return item;
        }
    }
    ,
    COMPLEX_TYPE("complexType", (schema, item, event) -> item.setAttributes(event.asStringMap()), new Tag[]{SchemaLeafTag.CHOICE, SchemaLeafTag.SEQUENCE, SchemaLeafTag.SIMPLE_CONTENT, SchemaLeafTag.ANNOTATION, SchemaLeafTag.ANYATTRIBUTE}){

        @Override
        public ComplexTypeObject getItem(SchemaObject schemaObject, OpenEvent event) {
            ComplexTypeObject item = new ComplexTypeObject(null);
            schemaObject.getComplexTypes().add(item);
            return item;
        }
    }
    ,
    SIMPLE_TYPE("simpleType", (schema, item, event) -> item.setAttributes(event.asStringMap()), new Tag[]{SchemaLeafTag.RESTRICTION, SchemaLeafTag.ANNOTATION, SchemaLeafTag.LIST}){

        @Override
        public SimpleTypeObject getItem(SchemaObject schemaObject, OpenEvent event) {
            SimpleTypeObject item = new SimpleTypeObject(null);
            schemaObject.getSimpleTypes().add(item);
            return item;
        }
    };

    private final String tag;
    private final boolean choice = true;
    private final StepOpener<SchemaObject, SchemaItem, OpenEvent> opener;
    private final boolean multiple = true;
    private final Tag<? super SchemaItem, ?>[] children;

    @SafeVarargs
    private SchemaReferenceTag(String tag, TriConsumer<SchemaObject, SchemaItem, OpenEvent> opener, Tag<? super SchemaItem, ?> ... children) {
        this.tag = tag;
        this.opener = Opener.stepOpener(opener);
        this.children = children;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isChoice() {
        this.getClass();
        return true;
    }

    public StepOpener<SchemaObject, SchemaItem, OpenEvent> getOpener() {
        return this.opener;
    }

    @Override
    public boolean isMultiple() {
        this.getClass();
        return true;
    }

    @Override
    public Tag<? super SchemaItem, ?>[] getChildren() {
        return this.children;
    }
}

