/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TriConsumer;
import com.brentcroft.tools.materializer.model.Closer;
import com.brentcroft.tools.materializer.model.FlatCacheCloser;
import com.brentcroft.tools.materializer.model.FlatCacheOpener;
import com.brentcroft.tools.materializer.model.FlatTag;
import com.brentcroft.tools.materializer.model.Opener;
import com.brentcroft.tools.materializer.util.SchemaElementTag;
import com.brentcroft.tools.materializer.util.SchemaItem;
import java.util.function.BiFunction;

enum SchemaLeafTag implements FlatTag<SchemaItem>
{
    ANYTHING("*", new Tag[0]){

        @Override
        public Tag<? super SchemaItem, ?>[] getChildren() {
            return Tag.tags(ANYTHING);
        }
    }
    ,
    CHOICE("choice", new Tag[]{null}){

        @Override
        public Tag<? super SchemaItem, ?>[] getChildren() {
            return Tag.tags(SchemaElementTag.ELEMENT, SEQUENCE, ANNOTATION, ANY);
        }
    }
    ,
    SEQUENCE("sequence", new Tag[]{null}){

        @Override
        public Tag<? super SchemaItem, ?>[] getChildren() {
            return Tag.tags(SchemaElementTag.ELEMENT, CHOICE, ANNOTATION, ANY);
        }
    }
    ,
    LENGTH("length", new Tag[0]),
    FRACTIONDIGITS("fractionDigits", new Tag[0]),
    TOTALDIGITS("totalDigits", new Tag[0]),
    MININCLUSIVE("minInclusive", new Tag[0]),
    MAXINCLUSIVE("maxInclusive", new Tag[0]),
    MINLENGTH("minLength", new Tag[0]),
    MAXLENGTH("maxLength", new Tag[0]),
    ATTRIBUTE("attribute", new Tag[0]),
    ANYATTRIBUTE("anyAttribute", ANYTHING),
    ATTRIBUTEGROUP("attributeGroup", new Tag[0]),
    PATTERN("pattern", new Tag[0]),
    LIST("list", new Tag[0]),
    EXTENSION("extension", ATTRIBUTE, ANYATTRIBUTE, CHOICE, SEQUENCE),
    ANY("any", new Tag[0]){

        @Override
        public Tag<? super SchemaItem, ?>[] getChildren() {
            return Tag.tags(ANYTHING);
        }
    }
    ,
    DOCUMENTATION("documentation", ANYTHING),
    ANNOTATION("annotation", DOCUMENTATION),
    ENUMERATION("enumeration", new Tag[0]),
    RESTRICTION("restriction", PATTERN, ENUMERATION, MINLENGTH, MAXLENGTH, TOTALDIGITS, LENGTH, MININCLUSIVE, MAXINCLUSIVE, FRACTIONDIGITS),
    SIMPLE_CONTENT("simpleContent", EXTENSION, ANNOTATION),
    SIMPLE_TYPE("simpleType", RESTRICTION, ANNOTATION),
    COMPLEX_TYPE("complexType", SEQUENCE, CHOICE, SIMPLE_CONTENT, ANNOTATION, ANYATTRIBUTE);

    private final String tag;
    private final boolean multiple = true;
    private final boolean choice = true;
    private final FlatCacheOpener<SchemaItem, OpenEvent, ?> opener;
    private final FlatCacheCloser<SchemaItem, String, ?> closer;
    private final Tag<? super SchemaItem, ?>[] children;

    @SafeVarargs
    private SchemaLeafTag(String tag, Tag<? super SchemaItem, ?> ... children) {
        this(tag, (BiFunction<SchemaItem, OpenEvent, C>)null, (TriConsumer<SchemaItem, String, C>)null, children);
    }

    @SafeVarargs
    private <C> SchemaLeafTag(String tag, BiFunction<SchemaItem, OpenEvent, C> opener, TriConsumer<SchemaItem, String, C> closer, Tag<? super SchemaItem, ?> ... children) {
        this.tag = tag;
        this.opener = Opener.flatCacheOpener(opener);
        this.closer = Closer.flatCacheCloser(closer);
        this.children = children;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isMultiple() {
        this.getClass();
        return true;
    }

    @Override
    public boolean isChoice() {
        this.getClass();
        return true;
    }

    public FlatCacheOpener<SchemaItem, OpenEvent, ?> getOpener() {
        return this.opener;
    }

    public FlatCacheCloser<SchemaItem, String, ?> getCloser() {
        return this.closer;
    }

    @Override
    public Tag<? super SchemaItem, ?>[] getChildren() {
        return this.children;
    }
}

