/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TriConsumer;
import com.brentcroft.tools.materializer.model.Closer;
import com.brentcroft.tools.materializer.model.FlatCacheCloser;
import com.brentcroft.tools.materializer.model.FlatCacheOpener;
import com.brentcroft.tools.materializer.model.FlatTag;
import com.brentcroft.tools.materializer.model.Opener;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;

public enum PropertiesRootTag implements FlatTag<Properties>
{
    ENTRY("entry", (properties, event) -> event.getAttribute("key"), (properties, text, cache) -> properties.setProperty((String)cache, (String)text), new Tag[0]),
    COMMENT("comment", new Tag[0]),
    PROPERTIES("*", ENTRY, COMMENT),
    ROOT("", PROPERTIES);

    private final String tag;
    private final boolean multiple;
    private final boolean choice;
    private final FlatCacheOpener<Properties, OpenEvent, ?> opener;
    private final FlatCacheCloser<Properties, String, ?> closer;
    private final Tag<? super Properties, ?>[] children;

    @SafeVarargs
    private PropertiesRootTag(String tag, Tag<? super Properties, ?> ... children) {
        this(tag, (BiFunction<Properties, OpenEvent, C>)null, (TriConsumer<Properties, String, C>)null, children);
    }

    @SafeVarargs
    private <C> PropertiesRootTag(String tag, BiFunction<Properties, OpenEvent, C> opener, TriConsumer<Properties, String, C> closer, Tag<? super Properties, ?> ... children) {
        this.tag = tag;
        this.multiple = Objects.isNull(children) || children.length == 0;
        this.opener = Opener.flatCacheOpener(opener);
        this.closer = Closer.flatCacheCloser(closer);
        this.choice = Objects.nonNull(children) && children.length > 0;
        this.children = children;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public boolean isChoice() {
        return this.choice;
    }

    public FlatCacheOpener<Properties, OpenEvent, ?> getOpener() {
        return this.opener;
    }

    public FlatCacheCloser<Properties, String, ?> getCloser() {
        return this.closer;
    }

    @Override
    public Tag<? super Properties, ?>[] getChildren() {
        return this.children;
    }
}

