/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.SchemaItem;
import com.brentcroft.tools.materializer.util.SchemaObject;
import com.brentcroft.tools.materializer.util.TagType;
import com.brentcroft.tools.materializer.util.TypeHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Mutator {
    private final String name;
    private final Class<?> argument;
    private final List<Mutator> children = new LinkedList<Mutator>();
    private Class<?> argumentType;
    private Mutator parent;
    private String tag;
    private TagType tagType;
    private Class<?> context;
    private Class<?> contextStep;
    private boolean optional = false;
    private boolean multiple = false;
    private boolean choice = false;
    private boolean linked;
    private int index = -1;
    private TypeHandler typeHandler;

    public Mutator(Method m) {
        this(m.getName(), m.getParameterTypes()[0]);
        Type type;
        Type[] types = m.getGenericParameterTypes();
        if (types.length > 0 && (type = types[0]) instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.argumentType = (Class)pType.getActualTypeArguments()[0];
        }
    }

    public static Mutator rootMutator(Class<?> clazz, SchemaObject schemaObject) {
        SchemaItem item;
        Mutator rootMutator = new Mutator("", clazz);
        rootMutator.setTagType(TagType.FLAT);
        rootMutator.setContext(clazz);
        rootMutator.setContextStep(clazz);
        Iterator<ElementObject> iterator = schemaObject.getRootObjects().iterator();
        while (iterator.hasNext() && !rootMutator.link(clazz, item = (SchemaItem)iterator.next(), schemaObject)) {
        }
        if (!rootMutator.isLinked()) {
            throw new RuntimeException("Root mutator was not linked.");
        }
        rootMutator.setTagType(TagType.FLAT);
        return rootMutator;
    }

    public String getBeanName() {
        return this.name.substring(3, 4).toLowerCase() + this.name.substring(4);
    }

    public String getArgumentTypeBeanName() {
        return Optional.ofNullable(this.argumentType).map(Class::getSimpleName).map(String::toLowerCase).orElse("");
    }

    public String getBeanGetter() {
        return "get" + this.name.substring(3);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.argument);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.argument);
    }

    public boolean isAssignable(TypeHandler typeHandler) {
        return this.getArgument().isAssignableFrom(typeHandler.getClazz()) || this.getArgument().isAssignableFrom(typeHandler.getClazzBoxed());
    }

    public boolean isChildOfCollectionOrMap() {
        return Optional.ofNullable(this.parent).map(Mutator::isCollectionOrMap).orElse(false);
    }

    public boolean isCollectionOrMap() {
        return this.isCollection() || this.isMap();
    }

    public TypeHandler getSimpleType(String type, SchemaObject schemaObject) {
        String xsdType = schemaObject.xsdName(type);
        if (Objects.isNull(xsdType)) {
            return null;
        }
        switch (xsdType) {
            case "boolean": {
                return TypeHandler.BOOLEAN;
            }
            case "string": {
                return TypeHandler.STRING;
            }
            case "short": {
                if (this.isAssignable(TypeHandler.SHORT)) {
                    return TypeHandler.SHORT;
                }
            }
            case "integer": {
                if (this.isAssignable(TypeHandler.INTEGER)) {
                    return TypeHandler.INTEGER;
                }
            }
            case "long": {
                return TypeHandler.LONG;
            }
            case "float": {
                if (this.isAssignable(TypeHandler.FLOAT)) {
                    return TypeHandler.FLOAT;
                }
            }
            case "double": {
                if (!this.isAssignable(TypeHandler.DOUBLE)) break;
                return TypeHandler.DOUBLE;
            }
        }
        return null;
    }

    public List<Mutator> getMutators() {
        if (this.isMap()) {
            Mutator m = new Mutator("setProperty", String.class);
            m.setParent(this);
            m.setTagType(TagType.FLAT);
            return Collections.singletonList(m);
        }
        List<Mutator> mutators = Optional.ofNullable(this.isCollection() ? this.getArgumentType() : this.getArgument()).map(c -> Stream.of(c.getMethods()).filter(m -> m.getParameterCount() == 1).filter(m -> m.getName().startsWith("set")).map(Mutator::new).peek(m -> m.setParent(this)).sorted(Comparator.comparing(Mutator::getName)).collect(Collectors.toList())).orElse(Collections.emptyList());
        for (int i = mutators.size() - 1; i > 0; --i) {
            Mutator m1 = mutators.get(i);
            Mutator m2 = mutators.get(i - 1);
            if (!m1.getName().equals(m2.getName())) continue;
            if (m1.getArgument().isAssignableFrom(m2.getArgument())) {
                mutators.remove(i);
                continue;
            }
            if (m2.getArgument().isAssignableFrom(m1.getArgument())) {
                mutators.remove(i - 1);
                continue;
            }
            throw new IllegalArgumentException(String.format("Arguments for overloaded method '%s' are not compatible: %s, %s", m1.getName(), m1.getArgument().getName(), m2.getArgument().getName()));
        }
        return mutators;
    }

    public boolean link(Class<?> contextClazz, SchemaItem schemaItem, SchemaObject schemaObject) {
        if (this.linked) {
            return false;
        }
        TypeHandler typeHandler = this.getSimpleType(schemaItem.getTypeRef(), schemaObject);
        if (Objects.nonNull((Object)typeHandler) && schemaItem.getReified().getChildren().size() > 1) {
            throw new RuntimeException(String.format("Simple type handler [%s] but more than one reified child: %s", new Object[]{typeHandler, schemaItem.getReified().getChildren().size()}));
        }
        List<Mutator> mutators = this.getMutators();
        if (Objects.nonNull((Object)typeHandler) && mutators.size() > 1) {
            return false;
        }
        TagType tagType = mutators.size() > 1 || Objects.isNull((Object)typeHandler) ? TagType.STEP : TagType.FLAT;
        Class<?> contextStepClazz = TagType.STEP.equals((Object)tagType) ? this.getArgument() : contextClazz;
        this.setTypeHandler(Objects.isNull((Object)typeHandler) ? TypeHandler.identify(contextStepClazz) : typeHandler);
        this.setTagType(tagType);
        if (Objects.isNull(this.getTag())) {
            this.setTag(schemaItem.getName());
        }
        this.setMultiple(schemaItem.isMultiple());
        this.setOptional(schemaItem.isOptional());
        this.setContext(contextClazz);
        this.setContextStep(contextStepClazz);
        if (mutators.size() > 0) {
            if (Objects.isNull(schemaItem.getChildren())) {
                throw new RuntimeException("isNull( stepItem.getChildren() )");
            }
            boolean unassigned = false;
            for (Mutator mutator : mutators) {
                boolean matched = false;
                String beanName = mutator.isCollection() ? mutator.getArgumentTypeBeanName() : mutator.getBeanName();
                for (SchemaItem schemaItem2 : schemaItem.getReified().getChildren()) {
                    String itemName;
                    SchemaItem reifiedChild = schemaItem2.getReified();
                    String string = itemName = Objects.nonNull(schemaItem2.getName()) ? schemaItem2.getName() : reifiedChild.getName();
                    if (!beanName.equals(itemName) && !beanName.equals(schemaObject.getHints().get(itemName))) continue;
                    mutator.setTag(itemName);
                    matched = mutator.link(this.isCollection() ? this.getArgumentType() : this.getContextStep(), reifiedChild, schemaObject);
                    if (!matched) continue;
                    break;
                }
                if (matched) continue;
                unassigned = true;
                break;
            }
            if (unassigned) {
                return false;
            }
            mutators.sort(Comparator.comparingInt(Mutator::getIndex));
        }
        this.index = schemaItem.getIndex();
        this.children.addAll(mutators);
        this.linked = true;
        return this.linked;
    }

    public void detectTables(List<Mutator> tables) {
        if (this.getTagType().equals((Object)TagType.STEP) && (this.isMap() || this.isCollection() || !this.children.isEmpty())) {
            tables.add(this);
        }
        for (Mutator mutator : this.getChildren()) {
            mutator.detectTables(tables);
        }
    }

    public String getPopulators() {
        List populators = this.children.stream().filter(c -> Objects.nonNull(c.getOpener())).map(Mutator::getOpener).collect(Collectors.toList());
        return populators.isEmpty() ? "" : String.join((CharSequence)";\n", populators) + ";";
    }

    public String getOpener() {
        return Optional.ofNullable(this.typeHandler).map(th -> th.getOpener(this)).orElse(null);
    }

    public String getCloser() {
        return Optional.ofNullable(this.typeHandler).map(th -> th.getCloser(this)).orElse(null);
    }

    public String toString() {
        String offset = "\n  ";
        return String.format("{" + offset + "name: \"%s\"," + offset + "parent: \"%s\"," + offset + "index: %s," + offset + "tag: \"%s\"," + offset + "tagType: \"%s\",%s%s%s%s%s%s%s" + offset + "children: %s }", new Object[]{this.name, Optional.ofNullable(this.parent).map(Mutator::getName).orElse(""), this.index, this.tag, this.tagType, Optional.ofNullable(this.context).map(Class::getSimpleName).map(s -> String.format(offset + "context: \"%s\",", s)).orElse(""), Optional.ofNullable(this.contextStep).map(Class::getSimpleName).map(s -> String.format(offset + "contextStep: \"%s\",", s)).orElse(""), Optional.ofNullable(this.argument).map(Class::getSimpleName).map(s -> String.format(offset + "argument: \"%s\",", s)).orElse(""), Optional.ofNullable(this.argumentType).map(Class::getSimpleName).map(s -> String.format(offset + "argumentType: \"%s\",", s)).orElse(""), this.optional ? String.format(offset + "optional: %s,", this.optional) : "", this.multiple ? String.format(offset + "multiple: %s,", this.multiple) : "", this.choice ? String.format(offset + "choice: %s,", this.choice) : "", this.children.size()});
    }

    public String jsonate(String indent) {
        String offset = "    ";
        return String.format(indent + "{ %n" + indent + offset + "name: \"%s\",%n" + indent + offset + "index: %s,%n" + indent + offset + "argument: \"%s\",%n" + indent + offset + "argumentType: \"%s\",%n" + indent + offset + "tag: \"%s\",%n" + indent + offset + "tagType: \"%s\",%n" + indent + offset + "context: \"%s\",%n" + indent + offset + "contextStep: \"%s\",%n" + indent + offset + "optional: %s,%n" + indent + offset + "multiple: %s,%n" + indent + offset + "choice: %s,%n" + indent + offset + "children: %s%n" + indent + "}", new Object[]{this.name, this.index, Optional.ofNullable(this.argument).map(Class::getSimpleName).orElse(null), Optional.ofNullable(this.argumentType).map(Class::getSimpleName).orElse(null), this.tag, this.tagType, this.context.getSimpleName(), this.contextStep.getSimpleName(), this.optional, this.multiple, this.choice, this.children.isEmpty() ? "[]" : "[ \n" + this.children.stream().map(c -> c.jsonate(indent + offset)).collect(Collectors.joining(", \n")) + " \n" + indent + offset + "]"});
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getArgument() {
        return this.argument;
    }

    public List<Mutator> getChildren() {
        return this.children;
    }

    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    public Mutator getParent() {
        return this.parent;
    }

    public String getTag() {
        return this.tag;
    }

    public TagType getTagType() {
        return this.tagType;
    }

    public Class<?> getContext() {
        return this.context;
    }

    public Class<?> getContextStep() {
        return this.contextStep;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public int getIndex() {
        return this.index;
    }

    public TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setArgumentType(Class<?> argumentType) {
        this.argumentType = argumentType;
    }

    public void setParent(Mutator parent) {
        this.parent = parent;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTagType(TagType tagType) {
        this.tagType = tagType;
    }

    public void setContext(Class<?> context) {
        this.context = context;
    }

    public void setContextStep(Class<?> contextStep) {
        this.contextStep = contextStep;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setChoice(boolean choice) {
        this.choice = choice;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setTypeHandler(TypeHandler typeHandler) {
        this.typeHandler = typeHandler;
    }

    public Mutator(String name, Class<?> argument) {
        this.name = name;
        this.argument = argument;
    }
}

