/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.model;

import com.brentcroft.tools.materializer.core.TriConsumer;
import com.brentcroft.tools.materializer.core.TriFunction;
import com.brentcroft.tools.materializer.model.FlatCacheOpener;
import com.brentcroft.tools.materializer.model.FlatOpener;
import com.brentcroft.tools.materializer.model.StepOpener;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public interface Opener<A, B, C, D>
extends TriFunction<A, B, C, D> {
    public static <A, B, C> FlatCacheOpener<A, B, C> flatCacheOpener(BiFunction<A, B, C> opener) {
        return (a, b, c) -> {
            if (Objects.nonNull(opener)) {
                return opener.apply(b, c);
            }
            return null;
        };
    }

    public static <A, B> FlatOpener<A, B> flatOpener(BiConsumer<A, B> opener) {
        return (a, b, c) -> {
            if (Objects.nonNull(opener)) {
                opener.accept(b, c);
            }
            return null;
        };
    }

    public static <A, B, C> StepOpener<A, B, C> stepOpener(TriConsumer<A, B, C> opener) {
        return (a, b, c) -> {
            if (Objects.nonNull(opener)) {
                opener.accept(a, b, c);
            }
            return null;
        };
    }

    public static <A, B, C> StepOpener<A, B, C> stepOpener(BiConsumer<B, C> opener) {
        return (a, b, c) -> {
            if (Objects.nonNull(opener)) {
                opener.accept(b, c);
            }
            return null;
        };
    }

    default public D open(A context, B item, C event) {
        return this.apply(context, item, event);
    }
}

