/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.model;

import com.brentcroft.tools.materializer.core.QuadConsumer;
import com.brentcroft.tools.materializer.core.TriConsumer;
import com.brentcroft.tools.materializer.model.FlatCacheCloser;
import com.brentcroft.tools.materializer.model.FlatCloser;
import com.brentcroft.tools.materializer.model.JumpCloser;
import com.brentcroft.tools.materializer.model.StepCloser;
import java.util.Optional;
import java.util.function.BiConsumer;

public interface Closer<A, B, C, D>
extends QuadConsumer<A, B, C, D> {
    public static <A, B> FlatCloser<A, B> flatCloser(BiConsumer<A, B> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(b, c));
    }

    public static <A, B, C> FlatCacheCloser<A, B, C> flatCacheCloser(TriConsumer<A, B, C> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(b, c, d));
    }

    public static <A, B, C> StepCloser<A, B, C> stepCloser(TriConsumer<A, B, C> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(a, b, c));
    }

    public static <A, B, C> StepCloser<A, B, C> stepCloser(BiConsumer<B, C> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(b, c));
    }

    public static <A, B> JumpCloser<A, B> jumpCloser(BiConsumer<A, B> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(a, b));
    }

    public static <A, B, C, D> Closer<A, B, C, D> noCacheCloser(BiConsumer<A, B> simpleCloser) {
        return (a, b, c, d) -> Optional.ofNullable(simpleCloser).ifPresent(closer -> closer.accept(a, b));
    }

    default public void close(A a, B b, C c, Object d) {
        this.accept(a, b, c, d);
    }
}

