/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.ValidationException;
import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TagModel<R> {
    private final Tag<?, R> parent;
    private final boolean choice;
    private final Tag<? super R, ?>[] children;
    private int index = -1;

    public Tag<? super R, ?> getTag(OpenEvent openEvent) {
        Tag<Object, ?> tag;
        if (Objects.isNull(this.children) || this.children.length == 0) {
            throw new ValidationException(this.parent, String.format("Unexpected tag '%s': no children expected.", openEvent.combinedTag()));
        }
        if (this.choice) {
            for (Tag<?, ?> tag2 : this.children) {
                if (Objects.isNull(tag2)) {
                    throw new ValidationException(this.parent, String.format("TagModel has empty child item: index=%s, parent=%s %s", this.index, this.parent.name(), this.parent.getTag()));
                }
                if (!tag2.matches(openEvent)) continue;
                return tag2;
            }
            throw new ValidationException(this.parent, String.format("Unexpected tag '%s': no choice of %s['%s'] matches any child: %s.", openEvent.combinedTag(), this.parent.name(), this.parent.getTag(), Stream.of(this.children).map(c -> String.format("%s['%s']", c.name(), c.getTag())).collect(Collectors.joining(", "))));
        }
        if (-1 < this.index && this.index < this.children.length && (tag = this.children[this.index]).matches(openEvent) && tag.isMultiple()) {
            return tag;
        }
        ++this.index;
        while (this.index < this.children.length) {
            tag = this.children[this.index];
            if (Objects.isNull(tag)) {
                throw new ValidationException(this.parent, String.format("TagModel has empty child item: index=%s, parent=%s %s", this.index, this.parent.name(), this.parent.getTag()));
            }
            if (tag.matches(openEvent)) {
                return tag;
            }
            if (!tag.isOptional()) {
                throw new ValidationException(this.parent, String.format("Unexpected tag '%s': mandatory tag %s['%s'] does not match.", openEvent.combinedTag(), tag.name(), tag.getTag()));
            }
            ++this.index;
        }
        throw new ValidationException(this.parent, String.format("Unexpected tag '%s': no child matches: %s.", openEvent.combinedTag(), Stream.of(this.children).map(c -> String.format("%s['%s']", c.name(), c.getTag())).collect(Collectors.joining(", "))));
    }

    public Tag<?, R> getParent() {
        return this.parent;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public Tag<? super R, ?>[] getChildren() {
        return this.children;
    }

    public int getIndex() {
        return this.index;
    }

    public TagModel(Tag<?, R> parent, boolean choice, Tag<? super R, ?>[] children) {
        this.parent = parent;
        this.choice = choice;
        this.children = children;
    }
}

