/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.ContextValue;
import com.brentcroft.tools.materializer.TagHandlerException;
import com.brentcroft.tools.materializer.ValidationException;
import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TagContext;
import com.brentcroft.tools.materializer.core.TagHandlerContext;
import com.brentcroft.tools.materializer.model.JumpTag;
import com.brentcroft.tools.materializer.model.StepTag;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagHandler<R>
extends DefaultHandler
implements TagHandlerContext {
    private Locator documentLocator;
    private final Stack<Object> itemStack = new Stack();
    private final Stack<TagContext> contextStack;
    private final ContextValue contextValue;
    private final StringBuilder characters = new StringBuilder();

    public TagHandler(R rootItem, TagContext rootContext, ContextValue contextValue) {
        this.contextStack = new Stack();
        this.contextStack.push(rootContext);
        this.itemStack.push(rootItem);
        this.contextValue = contextValue;
    }

    public TagHandler(R rootItem, Stack<TagContext> tagContextStack, ContextValue contextValue) {
        this.contextStack = tagContextStack;
        this.itemStack.push(rootItem);
        this.contextValue = contextValue;
    }

    @Override
    public String getPath() {
        return this.contextStack.stream().filter(t -> !t.getTag().isJump()).map(TagContext::getTag).map(Tag::getTag).collect(Collectors.joining("/"));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Object item;
        Tag<?, ?> tag;
        OpenEvent openEvent = new OpenEvent(uri, localName, qName, attributes, this, this.contextStack.peek().getEvent().inContext());
        this.characters.setLength(0);
        if (this.contextStack.isEmpty()) {
            throw new TagHandlerException((TagHandlerContext)this, String.format("Empty stack for localName: '%s'", openEvent.combinedTag()));
        }
        TagContext tagContext = this.contextStack.peek();
        if (Objects.isNull(tagContext.getModel())) {
            throw new TagHandlerException((TagHandlerContext)this, String.format("Unexpected tag '%s': %s does not accept children.", openEvent.combinedTag(), this.contextStack.peek()));
        }
        Object contextItem = this.itemStack.peek();
        try {
            tag = tagContext.getModel().getTag(openEvent);
            while (tag instanceof JumpTag) {
                Object jumpItem = ((JumpTag)tag).step(contextItem, openEvent);
                tagContext = new TagContext(openEvent, tag.open(contextItem, jumpItem, openEvent), tag, tag.getTagModel());
                this.contextStack.push(tagContext);
                this.itemStack.push(jumpItem);
                contextItem = jumpItem;
                tag = tag.getTagModel().getTag(openEvent);
            }
        }
        catch (ValidationException e) {
            throw new TagHandlerException((TagHandlerContext)this, (Throwable)e);
        }
        openEvent.setTag(tag);
        if (tag instanceof StepTag) {
            item = ((StepTag)tag).step(contextItem, openEvent);
            this.itemStack.push(item);
        } else {
            item = contextItem;
        }
        if (Objects.isNull(item)) {
            throw new TagHandlerException((TagHandlerContext)this, String.format("No item obtained for tag: %s", tag.getTag()));
        }
        this.contextStack.push(new TagContext(openEvent, tag.open(contextItem, item, openEvent), tag, tag.getTagModel()));
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Tag<?, ?> jumpTag;
        TagContext tagContext = this.contextStack.peek();
        OpenEvent event = tagContext.getEvent();
        Object cachedObject = tagContext.getCache();
        Tag<?, ?> tag = tagContext.getTag();
        if (Objects.nonNull(tag)) {
            Object item = tag instanceof StepTag ? this.itemStack.pop() : this.itemStack.peek();
            Object contextItem = this.itemStack.peek();
            String text = this.characters.toString();
            tag.close(contextItem, item, Optional.ofNullable(event.getContextValue()).map(cv -> cv.map("text", text)).orElse(text), cachedObject);
        }
        this.contextStack.pop();
        this.characters.setLength(0);
        Tag<?, ?> tag2 = jumpTag = this.contextStack.isEmpty() ? null : this.contextStack.peek().getTag();
        while (jumpTag instanceof JumpTag) {
            tagContext = this.contextStack.pop();
            Object item = this.itemStack.pop();
            Object contextItem = this.itemStack.peek();
            jumpTag.close(contextItem, item, null, tagContext.getCache());
            jumpTag = this.contextStack.isEmpty() ? null : this.contextStack.peek().getTag();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        throw spe;
    }

    @Override
    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    @Override
    public Stack<Object> getItemStack() {
        return this.itemStack;
    }

    @Override
    public Stack<TagContext> getContextStack() {
        return this.contextStack;
    }

    public ContextValue getContextValue() {
        return this.contextValue;
    }

    public StringBuilder getCharacters() {
        return this.characters;
    }

    @Override
    public void setDocumentLocator(Locator documentLocator) {
        this.documentLocator = documentLocator;
    }
}

