/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.ContextValue;
import com.brentcroft.tools.materializer.core.AttributesMap;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TagContext;
import com.brentcroft.tools.materializer.core.TagHandlerContext;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;

public class OpenEvent
extends AttributesMap {
    private final String uri;
    private final String localName;
    private final String qName;
    private ContextValue contextValue;
    private final TagHandlerContext tagHandler;
    private Tag<?, ?> tag;

    public OpenEvent(String uri, String localName, String qName, Attributes attributes, TagHandlerContext tagHandler, ContextValue contextValue) {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.tagHandler = tagHandler;
        this.contextValue = contextValue;
        if (Objects.nonNull(attributes)) {
            this.harvestAttributes(attributes);
        }
    }

    private OpenEvent(OpenEvent parent) {
        this.tag = parent.tag;
        this.uri = parent.uri;
        this.localName = parent.localName;
        this.qName = parent.qName;
        this.tagHandler = parent.tagHandler;
        this.contextValue = parent.inContext();
        this.putAll((Map<?, ?>)parent);
    }

    @Override
    public String toString() {
        return String.format("tag: %s (%s)", this.combinedTag(), this.tag);
    }

    private void harvestAttributes(Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String[] key = new String[]{attributes.getLocalName(i)};
            if (key[0].length() == 0) {
                key[0] = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            this.setProperty(key[0], Optional.ofNullable(this.contextValue).map(cv -> cv.map(key[0], value)).orElse(value));
        }
    }

    public String combinedTag() {
        return Objects.isNull(this.localName) || this.localName.isEmpty() ? this.qName : (Objects.isNull(this.qName) || this.qName.isEmpty() || this.localName.equals(this.qName) ? this.localName : String.format("%s | %s", this.localName, this.qName));
    }

    public String getTagHead() {
        return String.format("%s%s", this.combinedTag(), this.asMap().entrySet().stream().map(entry -> String.format(" %s=\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining()));
    }

    public void putContextValue(String key, Object value) {
        if (Objects.nonNull(this.contextValue)) {
            this.contextValue.put(key, value);
        }
    }

    public ContextValue inContext() {
        return Objects.nonNull(this.contextValue) ? this.contextValue.inContext() : null;
    }

    public TagContext inContext(Tag<?, ?> tag) {
        return new TagContext(new OpenEvent(this), null, tag, tag.getTagModel());
    }

    public boolean notOnStack(Tag<?, ?> tag) {
        return this.getTagHandler().notOnStack(tag, this);
    }

    public Stack<TagContext> stackInContext(Tag<?, ?> tag) {
        Stack<TagContext> stack = this.getTagHandler().getContextStack();
        stack.push(new TagContext(new OpenEvent(this), null, tag, tag.getTagModel()));
        return stack;
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQName() {
        return this.qName;
    }

    public ContextValue getContextValue() {
        return this.contextValue;
    }

    public TagHandlerContext getTagHandler() {
        return this.tagHandler;
    }

    public Tag<?, ?> getTag() {
        return this.tag;
    }

    public void setContextValue(ContextValue contextValue) {
        this.contextValue = contextValue;
    }

    public void setTag(Tag<?, ?> tag) {
        this.tag = tag;
    }
}

