/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.TagException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AttributesMap
extends Properties {
    public AttributesMap() {
        this((Properties)null);
    }

    public AttributesMap(Properties defaults) {
        super(defaults);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v)));
        return map;
    }

    public Map<String, String> asStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
        return map;
    }

    public <T> T applyAttribute(String key, boolean mandatory, T defaultValue, Function<String, T> getter, Consumer<T> setter) {
        T t = this.getAttribute(key, mandatory, defaultValue, getter);
        if (Objects.nonNull(t) || mandatory) {
            setter.accept(t);
        }
        return t;
    }

    public <V> V onHasAttribute(String key, Callable<V> caller) {
        try {
            return this.hasAttribute(key) ? (V)caller.call() : null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V onHasAttributeAnd(String key, Supplier<Boolean> and, Callable<V> caller) {
        try {
            return this.hasAttribute(key) && and.get() != false ? (V)caller.call() : null;
        }
        catch (TagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasAttribute(String key) {
        return this.containsKey(key) || Optional.ofNullable(this.defaults).map(d -> d instanceof AttributesMap ? ((AttributesMap)d).hasAttribute(key) : d.containsKey(key)).orElse(false) != false;
    }

    public <T> T getAttribute(String key, boolean mandatory, T defaultValue, Function<String, T> getter) {
        if (!this.hasAttribute(key)) {
            if (mandatory) {
                throw new IllegalArgumentException("Mandatory attribute is missing: " + key);
            }
            return defaultValue;
        }
        if (Objects.isNull(getter)) {
            return defaultValue;
        }
        return getter.apply(this.getProperty(key));
    }

    public <T> T getAttribute(String key, T defaultValue) {
        return this.getAttribute(key, false, defaultValue, null);
    }

    public <T> T applyAttribute(String key, boolean mandatory, Function<String, T> getter, Consumer<T> setter) {
        return this.applyAttribute(key, mandatory, null, getter, setter);
    }

    public <T> T getAttribute(String key, boolean mandatory, Function<String, T> getter) {
        return this.getAttribute(key, mandatory, null, getter);
    }

    public <T> T applyAttribute(String key, Function<String, T> getter, Consumer<T> setter) {
        return this.applyAttribute(key, true, null, getter, setter);
    }

    public <T> T getAttribute(String key, Function<String, T> getter) {
        return this.getAttribute(key, true, null, getter);
    }

    public <T> T applyAttribute(String key, T defaultValue, Consumer<T> setter) {
        return this.applyAttribute(key, false, defaultValue, null, setter);
    }

    public <T> T applyAttribute(String key, T defaultValue, Function<String, T> getter, Consumer<T> setter) {
        return this.applyAttribute(key, false, defaultValue, getter, setter);
    }

    public String applyAttribute(String key, String defaultValue, Consumer<String> setter) {
        return this.applyAttribute(key, false, defaultValue, String::valueOf, setter);
    }

    public String getAttribute(String key, String defaultValue) {
        return this.getAttribute(key, false, defaultValue, String::valueOf);
    }

    public String applyAttribute(String key, boolean mandatory, Consumer<String> setter) {
        return this.applyAttribute(key, mandatory, null, String::valueOf, setter);
    }

    public String getAttribute(String key, boolean mandatory) {
        return this.getAttribute(key, mandatory, null, String::valueOf);
    }

    public String applyAttribute(String key, Consumer<String> setter) {
        return this.applyAttribute(key, true, null, String::valueOf, setter);
    }

    public String getAttribute(String key) {
        return this.getAttribute(key, true, null, String::valueOf);
    }
}

