/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer;

import com.brentcroft.tools.materializer.core.TagHandlerContext;
import java.util.Objects;
import java.util.Optional;

public class TagException
extends RuntimeException {
    private final TagHandlerContext tagHandler;

    public TagException(TagHandlerContext tagHandler, Throwable cause) {
        super(Objects.isNull(cause) ? "-" : cause.getMessage(), cause);
        this.tagHandler = tagHandler;
    }

    public TagException(TagHandlerContext tagHandler, String message) {
        super(message);
        this.tagHandler = tagHandler;
    }

    @Override
    public String toString() {
        return String.format("%s [%s, path: %s]: %s", this.getClass().getSimpleName(), Optional.ofNullable(this.tagHandler.getDocumentLocator()).map(locator -> String.format("%s%sline: %s, col: %s", Optional.ofNullable(locator.getPublicId()).map(pid -> "system-id: " + pid + ", ").orElse(""), Optional.ofNullable(locator.getSystemId()).map(sid -> "system-id: " + sid + ", ").orElse(""), locator.getLineNumber(), locator.getColumnNumber())).orElse(""), this.tagHandler.getPath(), this.getMessage());
    }

    public TagHandlerContext getTagHandler() {
        return this.tagHandler;
    }
}

