/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer;

import com.brentcroft.tools.materializer.ContextValue;
import com.brentcroft.tools.materializer.TagException;
import com.brentcroft.tools.materializer.TagParseException;
import com.brentcroft.tools.materializer.TagValidationException;
import com.brentcroft.tools.materializer.ValidationException;
import com.brentcroft.tools.materializer.core.OpenEvent;
import com.brentcroft.tools.materializer.core.TagContext;
import com.brentcroft.tools.materializer.core.TagHandler;
import com.brentcroft.tools.materializer.model.FlatTag;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Materializer<R>
implements Function<InputSource, R> {
    private final Schema schema;
    private final SAXParserFactory saxParserFactory;
    private final List<SAXParser> parsers = new LinkedList<SAXParser>();
    private final Supplier<FlatTag<? super R>> rootTagSupplier;
    private final Supplier<R> rootItemSupplier;
    private Stack<TagContext> contextStack;
    private ContextValue contextValue;

    public Materializer(Supplier<FlatTag<? super R>> rootTagSupplier, Supplier<R> rootItemSupplier) {
        this(rootTagSupplier, rootItemSupplier, null);
    }

    public Materializer(Supplier<FlatTag<? super R>> rootTagSupplier, Supplier<R> rootItemSupplier, Stack<TagContext> contextStack) {
        this(null, 0, rootTagSupplier, rootItemSupplier, contextStack);
    }

    public Materializer(int initialPoolSize, Supplier<FlatTag<? super R>> rootTagSupplier, Supplier<R> rootItemSupplier) {
        this(null, initialPoolSize, rootTagSupplier, rootItemSupplier, null);
    }

    public Materializer(Schema schema, int initialPoolSize, Supplier<FlatTag<? super R>> rootTagSupplier, Supplier<R> rootItemSupplier) {
        this(schema, initialPoolSize, rootTagSupplier, rootItemSupplier, null);
    }

    public static <R> Stack<TagContext> newStackInContext(FlatTag<? super R> rootTag, ContextValue contextValue) {
        OpenEvent event = new OpenEvent(null, null, null, null, null, contextValue);
        event.setTag(rootTag);
        Stack<TagContext> stack = new Stack<TagContext>();
        stack.push(new TagContext(event, null, rootTag, rootTag.getTagModel()));
        return stack;
    }

    public Materializer(Schema schema, int initialPoolSize, Supplier<FlatTag<? super R>> rootTagSupplier, Supplier<R> rootItemSupplier, Stack<TagContext> contextStack) {
        this.schema = schema;
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.rootTagSupplier = rootTagSupplier;
        this.rootItemSupplier = rootItemSupplier;
        this.contextStack = contextStack;
        this.saxParserFactory.setNamespaceAware(true);
        if (Objects.nonNull(schema)) {
            this.saxParserFactory.setSchema(schema);
        }
        try {
            this.saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            for (int i = 0; i < initialPoolSize; ++i) {
                this.releaseParser(this.saxParserFactory.newSAXParser());
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Schema getSchemas(String ... uris) {
        List<String> schemaUris = Arrays.asList(uris);
        Source[] sources = schemaUris.stream().map(uri -> new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream((String)uri), (String)uri)).collect(Collectors.toList()).toArray(new Source[uris.length]);
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(String.format("Failed to load schema uris [%s]: %s", schemaUris, e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseParser(SAXParser parser) {
        if (Objects.nonNull(parser)) {
            List<SAXParser> list = this.parsers;
            synchronized (list) {
                this.parsers.add(parser);
            }
        }
    }

    public TagHandler<R> getDefaultHandler() {
        R rootItem = this.rootItemSupplier.get();
        return new TagHandler<R>(rootItem, this.contextStack, this.contextValue);
    }

    @Override
    public R apply(InputSource inputSource) {
        R rootItem = this.rootItemSupplier.get();
        Stack<TagContext> stack = Objects.nonNull(this.contextStack) ? this.contextStack : Materializer.newStackInContext(this.rootTagSupplier.get(), this.contextValue);
        TagHandler<R> tagHandler = new TagHandler<R>(rootItem, stack, this.contextValue);
        SAXParser parser = null;
        try {
            parser = this.getParser();
            parser.parse(inputSource, tagHandler);
        }
        catch (ParserConfigurationException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (SAXException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (IOException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (ValidationException e) {
            throw new TagValidationException(tagHandler, e);
        }
        catch (TagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TagException(tagHandler, (Throwable)e);
        }
        finally {
            this.releaseParser(parser);
            stack.pop();
        }
        return rootItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        List<SAXParser> list = this.parsers;
        synchronized (list) {
            if (this.parsers.isEmpty()) {
                return this.saxParserFactory.newSAXParser();
            }
            SAXParser parser = this.parsers.remove(0);
            parser.reset();
            return parser;
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SAXParserFactory getSaxParserFactory() {
        return this.saxParserFactory;
    }

    public List<SAXParser> getParsers() {
        return this.parsers;
    }

    public Supplier<FlatTag<? super R>> getRootTagSupplier() {
        return this.rootTagSupplier;
    }

    public Supplier<R> getRootItemSupplier() {
        return this.rootItemSupplier;
    }

    public Stack<TagContext> getContextStack() {
        return this.contextStack;
    }

    public ContextValue getContextValue() {
        return this.contextValue;
    }

    public void setContextValue(ContextValue contextValue) {
        this.contextValue = contextValue;
    }
}

