/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.Materializer;
import com.brentcroft.tools.materializer.core.Closer;
import com.brentcroft.tools.materializer.core.FlatTag;
import com.brentcroft.tools.materializer.core.Opener;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.util.SchemaObject;
import com.brentcroft.tools.materializer.util.SchemaReferenceTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public enum SchemaRootTag implements FlatTag<SchemaObject>
{
    ANYTHING("*", new Tag[0]){

        @Override
        public Tag<? super SchemaObject, ?>[] getChildren() {
            return Tag.tags(ANYTHING);
        }
    }
    ,
    IMPORT("import", Map.class, (schemaObject, attributes) -> Tag.getAttributesMap(attributes)){

        @Override
        public Closer<SchemaObject, String, Map<?, ?>> getCloser() {
            return (schemaObject, text, cache) -> {
                File currentLocus = new File(schemaObject.getSystemId());
                String systemId = String.format("%s/%s", currentLocus.getParent(), cache.get("schemaLocation"));
                Materializer<SchemaObject> materializer = new Materializer<SchemaObject>(() -> ROOT, () -> {
                    SchemaObject so = new SchemaObject();
                    so.setSystemId(systemId);
                    return so;
                });
                try {
                    SchemaObject importedSchemaObject = materializer.apply(new InputSource(new FileInputStream(systemId)));
                    importedSchemaObject.reify();
                    schemaObject.getRootObjects().addAll(importedSchemaObject.getRootObjects());
                    schemaObject.getComplexTypes().addAll(importedSchemaObject.getComplexTypes());
                    schemaObject.getSimpleTypes().addAll(importedSchemaObject.getSimpleTypes());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
    ,
    ATTRIBUTE("attribute", ANYTHING),
    ATTRIBUTEGROUP("attributeGroup", ANYTHING),
    SCHEMA("schema", (schemaObject, attributes) -> {
        Map<String, String> cacheMap = Tag.getAttributesMap(attributes);
        cacheMap.forEach((k, v) -> {
            if (k.startsWith("xmlns:")) {
                String prefix = k.substring(6);
                schemaObject.getNamespacePrefixes().put(prefix, (String)v);
                if ("http://www.w3.org/2001/XMLSchema".equals(v)) {
                    schemaObject.setXsdPrefix(prefix);
                }
            }
        });
        Optional.ofNullable(cacheMap.get("targetNamespace")).flatMap(targetNamespace -> schemaObject.getNamespacePrefixes().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(targetNamespace)).findAny().map(Map.Entry::getKey)).ifPresent(schemaObject::setLocalPrefix);
    }, IMPORT, SchemaReferenceTag.ELEMENT, SchemaReferenceTag.COMPLEX_TYPE, SchemaReferenceTag.SIMPLE_TYPE, ATTRIBUTE, ATTRIBUTEGROUP),
    ROOT("", SCHEMA);

    private final String tag;
    private final boolean multiple = true;
    private final boolean choice = true;
    private final FlatTag<SchemaObject> self = this;
    private final Opener<SchemaObject, Attributes, ?> opener;
    private final Tag<? super SchemaObject, ?>[] children;

    @SafeVarargs
    private SchemaRootTag(String tag, Tag<? super SchemaObject, ?> ... children) {
        this.tag = tag;
        this.opener = null;
        this.children = children;
    }

    @SafeVarargs
    private SchemaRootTag(String tag, BiConsumer<SchemaObject, Attributes> opener, Tag<? super SchemaObject, ?> ... children) {
        this.tag = tag;
        this.opener = Opener.noCacheOpener(opener);
        this.children = children;
    }

    private <T> SchemaRootTag(String tag, Class<T> cacheClass, Opener<SchemaObject, Attributes, T> opener) {
        this.tag = tag;
        this.opener = opener;
        this.children = Tag.tags(new Tag[0]);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isMultiple() {
        this.getClass();
        return true;
    }

    @Override
    public boolean isChoice() {
        this.getClass();
        return true;
    }

    public FlatTag<SchemaObject> getSelf() {
        return this.self;
    }

    @Override
    public Opener<SchemaObject, Attributes, ?> getOpener() {
        return this.opener;
    }

    @Override
    public Tag<? super SchemaObject, ?>[] getChildren() {
        return this.children;
    }
}

