/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.jstl.JstlTemplateManager;
import com.brentcroft.tools.jstl.MapBindings;
import com.brentcroft.tools.materializer.util.ComplexTypeObject;
import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.Mutator;
import com.brentcroft.tools.materializer.util.SchemaItem;
import com.brentcroft.tools.materializer.util.SimpleTypeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SchemaObject {
    protected final List<ElementObject> rootObjects = new LinkedList<ElementObject>();
    protected final List<ComplexTypeObject> complexTypes = new LinkedList<ComplexTypeObject>();
    protected final List<SimpleTypeObject> simpleTypes = new LinkedList<SimpleTypeObject>();
    protected final Map<String, String> namespacePrefixes = new HashMap<String, String>();
    protected final Map<String, String> hints = new HashMap<String, String>();
    private String localPrefix;
    private String xsdPrefix;
    private String systemId;

    public String toString() {
        return String.format("rootElements: %n systemId=%s%n localPrefix=%s%n namespaces: %n  %s%n roots: %n  %s%n complexTypes: %n  %s%n simpleTypes: %n  %s", this.systemId, Objects.nonNull(this.localPrefix) ? this.localPrefix : "", this.namespacePrefixes.entrySet().stream().map(entry -> String.format(" xmlns:%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n  ")), this.rootObjects.stream().map(SchemaItem::toString).collect(Collectors.joining("\n  ")), this.complexTypes.stream().map(SchemaItem::toString).collect(Collectors.joining("\n  ")), this.simpleTypes.stream().map(SchemaItem::toString).collect(Collectors.joining("\n  ")));
    }

    public void reify() {
        for (SchemaItem schemaItem : this.getSimpleTypes()) {
            schemaItem.reify(this);
        }
        for (SchemaItem schemaItem : this.getComplexTypes()) {
            schemaItem.reify(this);
        }
        for (SchemaItem schemaItem : this.getRootObjects()) {
            schemaItem.reify(this);
        }
    }

    public String localName(String ref) {
        if (Objects.isNull(ref)) {
            return null;
        }
        int i = ref.indexOf(58) + 1;
        if (i < 2) {
            return ref;
        }
        return ref.substring(i);
    }

    public String xsdName(String ref) {
        String localPrefix = this.getXsdPrefix();
        if (Objects.nonNull(ref) && Objects.nonNull(localPrefix) && ref.startsWith(localPrefix + ":")) {
            return ref.substring(localPrefix.length() + 1);
        }
        return ref;
    }

    public String generateSource(Mutator rootMutator, String templateUri, String packageName) {
        ArrayList<Mutator> stepTables = new ArrayList<Mutator>();
        rootMutator.detectTables(stepTables);
        JstlTemplateManager jstl = new JstlTemplateManager();
        Pattern p = Pattern.compile("&#\\d{3};");
        jstl.getELTemplateManager().setValueExpressionFilter(v -> Optional.ofNullable(v).filter(o -> o instanceof String).map(Object::toString).filter(s -> p.matcher((CharSequence)s).find()).map(s -> s.replace("&#125;", "}")).orElse(v));
        return jstl.expandUri(templateUri, (Map)new MapBindings().withEntry("packageName", (Object)packageName).withEntry("rootClass", rootMutator.getContext()).withEntry("root", (Object)rootMutator).withEntry("steps", stepTables));
    }

    public List<ElementObject> getRootObjects() {
        return this.rootObjects;
    }

    public List<ComplexTypeObject> getComplexTypes() {
        return this.complexTypes;
    }

    public List<SimpleTypeObject> getSimpleTypes() {
        return this.simpleTypes;
    }

    public Map<String, String> getNamespacePrefixes() {
        return this.namespacePrefixes;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public String getLocalPrefix() {
        return this.localPrefix;
    }

    public String getXsdPrefix() {
        return this.xsdPrefix;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLocalPrefix(String localPrefix) {
        this.localPrefix = localPrefix;
    }

    public void setXsdPrefix(String xsdPrefix) {
        this.xsdPrefix = xsdPrefix;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

