/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.SchemaObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SchemaItem {
    private final SchemaItem parent;
    private final int index;
    private final List<ElementObject> children = new LinkedList<ElementObject>();
    private SchemaItem reified;
    private Map<String, String> attributes;

    public SchemaItem(SchemaItem parent) {
        this.index = Optional.ofNullable(parent).map(p -> parent.getChildren().size()).orElse(0);
        this.parent = parent;
    }

    public void addElement(ElementObject schemaItem) {
        if (this == schemaItem) {
            throw new RuntimeException("Trying to add self as a child");
        }
        this.children.add(schemaItem);
    }

    public void reify(SchemaObject schemaObject) {
        if (Objects.isNull(this.reified)) {
            if (this.getChildren().isEmpty()) {
                if (Objects.nonNull(this.getRef())) {
                    String localRef = schemaObject.localName(this.getRef());
                    this.reified = schemaObject.getRootObjects().stream().filter(ro -> ro.getName().equals(localRef)).map(ro -> ro).findAny().orElse(null);
                    if (Objects.isNull(this.reified)) {
                        throw new IllegalArgumentException(String.format("Un-reified item ref: %s; %s", this, schemaObject.getSystemId()));
                    }
                } else if (Objects.nonNull(this.getTypeRef())) {
                    if (this.getTypeRef().startsWith(schemaObject.getXsdPrefix() + ":")) {
                        this.reified = this;
                    } else {
                        String localName = schemaObject.localName(this.getTypeRef());
                        this.reified = schemaObject.getComplexTypes().stream().filter(ct -> ct.getName().equals(localName)).map(ct -> ct).findAny().orElseGet(() -> schemaObject.getSimpleTypes().stream().filter(ct -> ct.getName().equals(localName)).findAny().orElse(null));
                        if (Objects.isNull(this.reified)) {
                            throw new IllegalArgumentException(String.format("Un-reified type ref: %s; %s", this, schemaObject.getSystemId()));
                        }
                    }
                } else {
                    this.reified = this;
                }
            } else {
                for (SchemaItem schemaItem : this.getChildren()) {
                    schemaItem.reify(schemaObject);
                }
                this.reified = this;
            }
        }
    }

    public String getName() {
        return this.attributes.get("name");
    }

    public String getTypeRef() {
        return this.attributes.get("type");
    }

    public String getRef() {
        return this.attributes.get("ref");
    }

    public boolean isOptional() {
        return Optional.ofNullable(this.attributes.get("minOccurs")).filter(minOccurs -> minOccurs.equals("0")).isPresent();
    }

    public boolean isMultiple() {
        return Optional.ofNullable(this.attributes.get("maxOccurs")).filter(maxOccurs -> maxOccurs.equals("unbounded")).isPresent();
    }

    private String depth() {
        return this.parent == null ? "  " : "  " + this.parent.depth();
    }

    public String toString() {
        return String.format("%s %s", this.depth() + (Objects.isNull(this.attributes) ? "" : this.attributes), this.children.size() == 0 ? "" : "\n" + this.children.stream().map(SchemaItem::toString).collect(Collectors.joining("\n")));
    }

    public SchemaItem getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public List<ElementObject> getChildren() {
        return this.children;
    }

    public SchemaItem getReified() {
        return this.reified;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

