/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.ValidationException;
import org.xml.sax.Attributes;

public class TagModel<R> {
    private final Tag<?, R> parent;
    private final boolean choice;
    private final Tag<? super R, ?>[] children;
    private int index = -1;

    public Tag<? super R, ?> getTag(String uri, String localName, String qName, Attributes attributes) {
        Tag<Object, ?> tag;
        if (this.choice) {
            for (Tag<?, ?> tag2 : this.children) {
                if (!tag2.matches(uri, localName, qName, attributes)) continue;
                return tag2;
            }
            throw new ValidationException(this.parent, String.format("Unexpected tag: no choice of '%s' matches localName '%s'", this.parent.getTag(), localName));
        }
        if (-1 < this.index && this.index < this.children.length && (tag = this.children[this.index]).matches(uri, localName, qName, attributes) && tag.isMultiple()) {
            return tag;
        }
        ++this.index;
        while (this.index < this.children.length) {
            tag = this.children[this.index];
            if (tag.matches(uri, localName, qName, attributes)) {
                return tag;
            }
            if (!tag.isOptional()) {
                throw new ValidationException(this.parent, String.format("Unexpected tag: mandatory tag <%s> does not match localName <%s>", tag.getTag(), localName));
            }
            ++this.index;
        }
        throw new ValidationException(this.parent, String.format("Unexpected tag: no child matches localName <%s>", localName));
    }

    public Tag<?, R> getParent() {
        return this.parent;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public Tag<? super R, ?>[] getChildren() {
        return this.children;
    }

    public int getIndex() {
        return this.index;
    }

    public TagModel(Tag<?, R> parent, boolean choice, Tag<? super R, ?>[] children) {
        this.parent = parent;
        this.choice = choice;
        this.children = children;
    }
}

