/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.core.Closer;
import com.brentcroft.tools.materializer.core.Opener;
import com.brentcroft.tools.materializer.core.TagModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.xml.sax.Attributes;

public interface Tag<T, R> {
    @SafeVarargs
    public static <X> Tag<? super X, ?>[] tags(Tag<? super X, ?> ... tags) {
        return tags;
    }

    public static Map<String, String> getAttributesMap(Attributes attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String key = attributes.getLocalName(i);
            if (key.length() == 0) {
                key = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            map.put(key, value);
        }
        return map;
    }

    public String getTag();

    public R getItem(T var1);

    public Tag<T, R> getSelf();

    public Object open(Object var1, Attributes var2);

    public void close(Object var1, String var2, Object var3);

    default public Tag<? super R, ?>[] getChildren() {
        return null;
    }

    default public TagModel<? super R> getTagModel() {
        return Objects.isNull(this.getChildren()) || this.getChildren().length == 0 ? null : new TagModel<R>(this.getSelf(), this.isChoice(), this.getChildren());
    }

    default public boolean matches(String uri, String localName, String qName, Attributes attributes) {
        return this.getTag().equals("*") || this.getTag().equals(localName);
    }

    default public boolean isChoice() {
        return false;
    }

    default public boolean isOptional() {
        return false;
    }

    default public boolean isMultiple() {
        return false;
    }

    default public Opener<R, Attributes, ?> getOpener() {
        return null;
    }

    default public Closer<R, String, ?> getCloser() {
        return null;
    }

    default public BiConsumer<Tag<T, R>, R> getValidator() {
        return null;
    }
}

