/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.materializer.core.Opener;
import com.brentcroft.tools.materializer.core.StepTag;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.util.ComplexTypeObject;
import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.SchemaItem;
import com.brentcroft.tools.materializer.util.SchemaLeafTag;
import com.brentcroft.tools.materializer.util.SchemaObject;
import com.brentcroft.tools.materializer.util.SimpleTypeObject;
import java.util.function.BiConsumer;
import org.xml.sax.Attributes;

enum SchemaReferenceTag implements StepTag<SchemaObject, SchemaItem>
{
    ELEMENT("element", (item, attributes) -> item.setAttributes(Tag.getAttributesMap(attributes)), new Tag[]{SchemaLeafTag.COMPLEX_TYPE, SchemaLeafTag.SIMPLE_TYPE, SchemaLeafTag.ANNOTATION}){

        @Override
        public ElementObject getItem(SchemaObject schemaObject) {
            ElementObject item = new ElementObject(null);
            schemaObject.getRootObjects().add(item);
            return item;
        }
    }
    ,
    COMPLEX_TYPE("complexType", (item, attributes) -> item.setAttributes(Tag.getAttributesMap(attributes)), new Tag[]{SchemaLeafTag.CHOICE, SchemaLeafTag.SEQUENCE, SchemaLeafTag.SIMPLE_CONTENT, SchemaLeafTag.ANNOTATION}){

        @Override
        public ComplexTypeObject getItem(SchemaObject schemaObject) {
            ComplexTypeObject item = new ComplexTypeObject(null);
            schemaObject.getComplexTypes().add(item);
            return item;
        }
    }
    ,
    SIMPLE_TYPE("simpleType", (item, attributes) -> item.setAttributes(Tag.getAttributesMap(attributes)), new Tag[]{SchemaLeafTag.RESTRICTION, SchemaLeafTag.ANNOTATION}){

        @Override
        public SimpleTypeObject getItem(SchemaObject schemaObject) {
            SimpleTypeObject item = new SimpleTypeObject(null);
            schemaObject.getSimpleTypes().add(item);
            return item;
        }
    };

    private final String tag;
    private final StepTag<SchemaObject, SchemaItem> self = this;
    private final boolean choice = true;
    private final Opener<SchemaItem, Attributes, ?> opener;
    private final boolean multiple = true;
    private final Tag<? super SchemaItem, ?>[] children;

    @SafeVarargs
    private SchemaReferenceTag(String tag, BiConsumer<SchemaItem, Attributes> opener, Tag<? super SchemaItem, ?> ... children) {
        this.tag = tag;
        this.opener = Opener.noCacheOpener(opener);
        this.children = children;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public StepTag<SchemaObject, SchemaItem> getSelf() {
        return this.self;
    }

    @Override
    public boolean isChoice() {
        this.getClass();
        return true;
    }

    @Override
    public Opener<SchemaItem, Attributes, ?> getOpener() {
        return this.opener;
    }

    @Override
    public boolean isMultiple() {
        this.getClass();
        return true;
    }

    @Override
    public Tag<? super SchemaItem, ?>[] getChildren() {
        return this.children;
    }
}

