/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.TagHandlerException;
import com.brentcroft.tools.materializer.core.FlatTag;
import com.brentcroft.tools.materializer.core.StepTag;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TagModel;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagHandler<R>
extends DefaultHandler {
    private final Stack<Object> itemStack = new Stack();
    private final Stack<Object> cacheStack = new Stack();
    private final Stack<Tag<?, ?>> tagStack = new Stack();
    private final Stack<TagModel<?>> tagModelStack = new Stack();
    private final StringBuilder characters = new StringBuilder();

    public TagHandler(FlatTag<? super R> rootTag, R rootItem) {
        this.tagStack.push(rootTag);
        this.itemStack.push(rootItem);
        this.tagModelStack.push(rootTag.getTagModel());
    }

    public String getPath() {
        return this.tagStack.stream().map(Tag::getTag).collect(Collectors.joining("/"));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.characters.setLength(0);
        if (this.tagModelStack.isEmpty()) {
            throw new TagHandlerException(this, String.format("No model on stack for tag: <%s>", localName));
        }
        if (Objects.isNull(this.tagModelStack.peek())) {
            throw new TagHandlerException(this, String.format("isNull( tagModelStack.peek() ) is null for tag: <%s>", localName));
        }
        Tag<?, ?> tag = this.tagModelStack.peek().getTag(uri, localName, qName, attributes);
        Object item = this.itemStack.peek();
        if (tag instanceof StepTag) {
            item = ((StepTag)tag).step(item);
            this.itemStack.push(item);
        }
        if (Objects.isNull(item)) {
            throw new TagHandlerException(this, String.format("No item obtained for tag: <%s>", tag.getTag()));
        }
        this.tagStack.push(tag);
        this.tagModelStack.push(tag.getTagModel());
        this.cacheStack.push(tag.open(item, attributes));
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Object cachedObject = this.cacheStack.pop();
        Tag<?, ?> tag = this.tagStack.pop();
        if (Objects.nonNull(tag)) {
            Object item = this.itemStack.peek();
            tag.close(item, this.characters.toString().trim(), cachedObject);
            if (tag instanceof StepTag) {
                this.itemStack.pop();
            }
        }
        this.tagModelStack.pop();
        this.characters.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Stack<Object> getItemStack() {
        return this.itemStack;
    }

    public Stack<Object> getCacheStack() {
        return this.cacheStack;
    }

    public Stack<Tag<?, ?>> getTagStack() {
        return this.tagStack;
    }

    public Stack<TagModel<?>> getTagModelStack() {
        return this.tagModelStack;
    }

    public StringBuilder getCharacters() {
        return this.characters;
    }
}

