/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.core.Closer;
import com.brentcroft.tools.materializer.core.Opener;
import com.brentcroft.tools.materializer.core.TagModel;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.xml.sax.Attributes;

public interface Tag<T, R> {
    public String getTag();

    public R getItem(T var1);

    public Tag<T, R> getSelf();

    public Object open(Object var1, Attributes var2);

    @SafeVarargs
    public static <X> Tag<? super X, ?>[] tags(Tag<? super X, ?> ... tags) {
        return tags;
    }

    public static Map<String, String> getAttributesMap(Attributes attributes) {
        return IntStream.range(0, attributes.getLength()).mapToObj(index -> new String[]{attributes.getLocalName(index), attributes.getValue(index)}).collect(Collectors.toMap(keys -> keys[0], keys -> keys[1]));
    }

    public void close(Object var1, String var2, Object var3);

    default public Tag<? super R, ?>[] getChildren() {
        return null;
    }

    default public TagModel<? super R> getTagModel() {
        return Objects.isNull(this.getChildren()) || this.getChildren().length == 0 ? null : new TagModel<R>(this.getSelf(), this.isChoice(), this.getChildren());
    }

    default public boolean matches(String uri, String localName, String qName, Attributes attributes) {
        return this.getTag().equals("*") || this.getTag().equals(localName);
    }

    default public boolean isChoice() {
        return false;
    }

    default public boolean isOptional() {
        return false;
    }

    default public boolean isMultiple() {
        return false;
    }

    default public Opener<R, Attributes, ?> getOpener() {
        return null;
    }

    default public Closer<R, String, ?> getCloser() {
        return null;
    }

    default public BiConsumer<Tag<T, R>, R> getValidator() {
        return null;
    }
}

