/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.TagHandlerException;
import com.brentcroft.tools.materializer.core.StepTag;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TagModel;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagHandler
extends DefaultHandler {
    private final Stack<Object> rootItemStack = new Stack();
    private final Stack<Tag<?, ?>> tagStack = new Stack();
    private final Stack<TagModel> tagModelStack = new Stack();
    private final StringBuilder characters = new StringBuilder();
    private Tag<?, ?> lastTag;

    public TagHandler(Tag<?, ?> rootTag, Object rootItem) {
        this.rootItemStack.push(rootItem);
        this.tagStack.push(rootTag);
        this.tagModelStack.push(rootTag.getTagModel());
    }

    public String getPath() {
        return this.tagStack.stream().map(Tag::getTag).collect(Collectors.joining("/"));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.characters.setLength(0);
        if (Objects.isNull(this.tagModelStack.peek())) {
            throw new TagHandlerException(this, String.format("No model on stack for tag: <%s>", localName));
        }
        Tag<?, ?> tag = this.tagModelStack.peek().getTag(uri, localName, qName, attributes);
        Object item = this.rootItemStack.peek();
        if (tag instanceof StepTag) {
            item = ((StepTag)tag).step(item);
            this.rootItemStack.push(item);
        }
        if (Objects.isNull(item)) {
            throw new TagHandlerException(this, String.format("No item obtained for tag: <%s>", tag.getTag()));
        }
        this.tagStack.push(tag);
        this.tagModelStack.push(tag.getTagModel());
        tag.open(item, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Tag<?, ?> tag = this.tagStack.peek();
        if (Objects.nonNull(tag)) {
            Object item = this.rootItemStack.peek();
            tag.close(item, this.characters.toString().trim());
            if (tag instanceof StepTag) {
                this.rootItemStack.pop();
            }
        }
        this.lastTag = tag;
        this.tagModelStack.pop();
        this.tagStack.pop();
        this.characters.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Stack<Object> getRootItemStack() {
        return this.rootItemStack;
    }

    public Stack<Tag<?, ?>> getTagStack() {
        return this.tagStack;
    }

    public Stack<TagModel> getTagModelStack() {
        return this.tagModelStack;
    }

    public StringBuilder getCharacters() {
        return this.characters;
    }

    public Tag<?, ?> getLastTag() {
        return this.lastTag;
    }
}

