/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer;

import com.brentcroft.tools.materializer.TagException;
import com.brentcroft.tools.materializer.TagParseException;
import com.brentcroft.tools.materializer.TagValidationException;
import com.brentcroft.tools.materializer.core.FlatTag;
import com.brentcroft.tools.materializer.core.Tag;
import com.brentcroft.tools.materializer.core.TagHandler;
import com.brentcroft.tools.materializer.core.ValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Materializer<R>
implements Function<InputSource, R> {
    private final Schema schema;
    private final SAXParserFactory saxParserFactory;
    private final List<SAXParser> parsers = new LinkedList<SAXParser>();
    private final Supplier<FlatTag<?>> rootTagSupplier;
    private final Supplier<R> rootItemSupplier;

    public Materializer(Schema schema, int initialPoolSize, Supplier<FlatTag<?>> rootTagSupplier, Supplier<R> rootItemSupplier) {
        this.schema = schema;
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.rootTagSupplier = rootTagSupplier;
        this.rootItemSupplier = rootItemSupplier;
        this.saxParserFactory.setNamespaceAware(true);
        if (Objects.nonNull(schema)) {
            this.saxParserFactory.setSchema(schema);
        }
        try {
            for (int i = 0; i < initialPoolSize; ++i) {
                this.releaseParser(this.saxParserFactory.newSAXParser());
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseParser(SAXParser parser) {
        if (Objects.nonNull(parser)) {
            List<SAXParser> list = this.parsers;
            synchronized (list) {
                this.parsers.add(parser);
            }
        }
    }

    @Override
    public R apply(InputSource inputSource) {
        R rootItem = this.rootItemSupplier.get();
        TagHandler tagHandler = new TagHandler((Tag)this.rootTagSupplier.get(), rootItem);
        SAXParser parser = null;
        try {
            parser = this.getParser();
            parser.parse(inputSource, (DefaultHandler)tagHandler);
        }
        catch (ParserConfigurationException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (SAXException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (IOException e) {
            throw new TagParseException(tagHandler, e);
        }
        catch (ValidationException e) {
            throw new TagValidationException(tagHandler, e);
        }
        catch (TagException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TagException(tagHandler, (Throwable)e);
        }
        finally {
            this.releaseParser(parser);
        }
        return rootItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        List<SAXParser> list = this.parsers;
        synchronized (list) {
            if (this.parsers.isEmpty()) {
                return this.saxParserFactory.newSAXParser();
            }
            SAXParser parser = this.parsers.remove(0);
            parser.reset();
            return parser;
        }
    }

    public static Schema getSchemas(String ... uris) {
        List<String> schemaUris = Arrays.asList(uris);
        Source[] sources = schemaUris.stream().map(uri -> new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream((String)uri), (String)uri)).collect(Collectors.toList()).toArray(new Source[uris.length]);
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(String.format("Failed to load schema uris [%s]: %s", schemaUris, e.getMessage()), e);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SAXParserFactory getSaxParserFactory() {
        return this.saxParserFactory;
    }

    public List<SAXParser> getParsers() {
        return this.parsers;
    }

    public Supplier<FlatTag<?>> getRootTagSupplier() {
        return this.rootTagSupplier;
    }

    public Supplier<R> getRootItemSupplier() {
        return this.rootItemSupplier;
    }
}

