/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import com.brentcroft.tools.materializer.TagHandlerException;
import com.brentcroft.tools.materializer.core.Tag;
import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.Collectors;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagHandler
extends DefaultHandler {
    private final Stack<Object> rootItemStack = new Stack();
    private final Stack<Tag<?, ?>> tagStack = new Stack();
    private final Stack<Iterator<Tag<?, ?>>> tagStackIterator = new Stack();
    private final StringBuilder characters = new StringBuilder();
    private Tag<?, ?> lastSibling;

    public TagHandler(Tag<?, ?> rootTag, Object rootItem) {
        this.rootItemStack.push(rootItem);
        this.tagStack.push(rootTag);
        this.tagStackIterator.push(rootTag.getIterator());
    }

    public String getPath() {
        return this.tagStack.stream().map(Tag::getTag).collect(Collectors.joining("/"));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Object rootItem;
        this.characters.setLength(0);
        Tag<?, ?> tag = Objects.nonNull(this.lastSibling) && this.lastSibling.getTag().equals(localName) && this.lastSibling.isMultiple() ? this.lastSibling : null;
        this.lastSibling = null;
        if (Objects.isNull(tag)) {
            Tag<?, ?> tag2 = tag = this.tagStackIterator.peek().hasNext() ? this.tagStackIterator.peek().next() : null;
            if (Objects.isNull(tag)) {
                throw new TagHandlerException(this, String.format("No element expected: <%s>; %s", localName, tag));
            }
            while (!tag.getTag().equals(localName) && tag.isOptional()) {
                tag = this.tagStackIterator.peek().next();
            }
            if (!tag.getTag().equals(localName)) {
                throw new TagHandlerException(this, String.format("Unexpected element: <%s>; expected: <%s>", localName, tag.getTag()));
            }
        }
        if (Objects.isNull(rootItem = tag.upcastItem(this.rootItemStack.peek()))) {
            throw new TagHandlerException(this, String.format("No item obtained for tag: <%s>", tag.getTag()));
        }
        this.rootItemStack.push(rootItem);
        this.tagStack.push(tag);
        this.tagStackIterator.push(tag.getIterator());
        tag.open(rootItem, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.lastSibling = this.tagStack.peek();
        Object rootItem = this.rootItemStack.peek();
        if (Objects.nonNull(this.lastSibling)) {
            this.lastSibling.close(rootItem, this.characters.toString().trim());
        }
        this.rootItemStack.pop();
        this.tagStackIterator.pop();
        this.tagStack.pop();
        this.characters.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Stack<Object> getRootItemStack() {
        return this.rootItemStack;
    }

    public Stack<Tag<?, ?>> getTagStack() {
        return this.tagStack;
    }

    public Stack<Iterator<Tag<?, ?>>> getTagStackIterator() {
        return this.tagStackIterator;
    }

    public StringBuilder getCharacters() {
        return this.characters;
    }

    public Tag<?, ?> getLastSibling() {
        return this.lastSibling;
    }
}

