/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.xml.sax.Attributes;

public interface Tag<T, R> {
    public String getTag();

    public R getItem(T var1);

    public Tag<T, R> getSelf();

    public static List<Tag<?, ?>> fromArray(Tag<?, ?> ... tags) {
        return Optional.ofNullable(tags).map(Arrays::asList).orElse(null);
    }

    default public T upcast(Object o) {
        return (T)o;
    }

    default public R sidecast(Object o) {
        return (R)o;
    }

    default public R upcastItem(Object o) {
        return this.getItem(this.upcast(o));
    }

    default public List<Tag<?, ?>> getChildren() {
        return null;
    }

    default public boolean isOptional() {
        return false;
    }

    default public boolean isMultiple() {
        return false;
    }

    default public BiConsumer<R, Attributes> getOpener() {
        return null;
    }

    default public BiConsumer<R, String> getCloser() {
        return null;
    }

    default public BiConsumer<Tag<T, R>, R> getValidator() {
        return null;
    }

    default public void open(Object o, Attributes attributes) {
        Object r = this.sidecast(o);
        Optional.ofNullable(this.getOpener()).ifPresent(opener -> opener.accept(r, attributes));
    }

    default public void close(Object o, String text) {
        Object r = this.sidecast(o);
        Optional.ofNullable(this.getCloser()).ifPresent(closer -> closer.accept(r, text));
        Optional.ofNullable(this.getValidator()).ifPresent(validator -> validator.accept(this.getSelf(), r));
    }

    default public Iterator<Tag<?, ?>> getIterator() {
        return Optional.ofNullable(this.getChildren()).orElse(Collections.emptyList()).iterator();
    }

    public static interface FlatTag<T>
    extends Tag<T, T> {
        @Override
        default public T getItem(T t) {
            return t;
        }
    }
}

