/*
 * Decompiled with CFR 0.152.
 */
package com.brainx.piccroplibrary.BXHelpers;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.location.Address;
import android.location.Geocoder;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.Toolbar;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.View;
import android.webkit.MimeTypeMap;
import android.widget.TextView;
import com.brainx.piccroplibrary.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class BXUtils {
    public static String convertStringToPascal(String str) {
        String newString = "";
        if (!(str = str.toLowerCase()).isEmpty()) {
            String[] arr;
            for (String val : arr = str.split(" ")) {
                newString = newString + String.valueOf(val.charAt(0)).toUpperCase() + val.substring(1, val.length()) + " ";
            }
            return newString.trim();
        }
        return str;
    }

    public static Uri getUriFromFile(Context context, File file) {
        if (Build.VERSION.SDK_INT < 24) {
            return Uri.fromFile((File)file);
        }
        return FileProvider.getUriForFile((Context)context, (String)"com.brainx.piccroplibrary.provider", (File)file);
    }

    public static void deleteImageFromExternalStorage(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
    }

    public static Bitmap getScaledImage(Bitmap bitmap, int desiredSide) throws OutOfMemoryError {
        int srcHeight;
        int srcWidth = bitmap.getWidth();
        float desiredScale = srcWidth > (srcHeight = bitmap.getHeight()) ? (float)desiredSide / (float)srcWidth : (float)desiredSide / (float)srcHeight;
        if (desiredScale < 1.0f) {
            Matrix matrix = new Matrix();
            matrix.postScale(desiredScale, desiredScale);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromPath(String filePath) {
        File image = new File(filePath);
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        return BitmapFactory.decodeFile((String)image.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public static String getDate() {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
        return df.format(c.getTime());
    }

    public static String getStringFromBitmap(Bitmap bitmap) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bao);
        byte[] ba = bao.toByteArray();
        return BXUtils.encodeImage(ba);
    }

    private static String encodeImage(byte[] imageByteArray) {
        return Base64.encodeToString((byte[])imageByteArray, (int)0);
    }

    public static Bitmap getSquareScaledImage(Bitmap bitmap, int desiredSide) throws OutOfMemoryError {
        int srcHeight;
        int srcWidth = bitmap.getWidth();
        float desiredScale = srcWidth > (srcHeight = bitmap.getHeight()) ? (float)desiredSide / (float)srcWidth : (float)desiredSide / (float)srcHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(desiredScale, desiredScale);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static boolean correctRotationForCameraPic(String path) {
        int rotate = BXUtils.getImageOrientation(path);
        Bitmap bitmap = BitmapFactory.decodeFile((String)path);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotate);
        Bitmap bmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        try {
            FileOutputStream fos = new FileOutputStream(path);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static int getImageOrientation(String imagePath) {
        int rotate = 0;
        try {
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rotate;
    }

    public static void applyFontForToolbarTitle(Activity context, String font) {
        Toolbar toolbar = (Toolbar)context.findViewById(R.id.toolbar);
        if (toolbar != null) {
            for (int i = 0; i < toolbar.getChildCount(); ++i) {
                View view = toolbar.getChildAt(i);
                if (!(view instanceof TextView)) continue;
                TextView tv = (TextView)view;
                Typeface titleFont = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
                if (!tv.getText().equals(toolbar.getTitle())) continue;
                tv.setTypeface(titleFont);
                break;
            }
        }
    }

    public static int dpToPx(int dp, Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round((float)dp * (displayMetrics.xdpi / 160.0f));
    }

    public static int getViewRelativeTop(View myView, View parent) {
        if (myView.getParent() == parent) {
            return myView.getTop();
        }
        return myView.getTop() + BXUtils.getViewRelativeTop((View)myView.getParent(), parent);
    }

    public static String imageNameCreate() {
        Random rand = new Random();
        String date = new SimpleDateFormat("yyyyMMddHHmmss'.jpg'").format(new Date());
        return date;
    }

    public static String getCompleteAddressString(Context c, double LATITUDE, double LONGITUDE) {
        String strAdd = "(GPS location unavailable)";
        Geocoder geocoder = new Geocoder(c, Locale.getDefault());
        try {
            List addresses = geocoder.getFromLocation(LATITUDE, LONGITUDE, 1);
            if (addresses != null && addresses.size() != 0) {
                Address returnedAddress = (Address)addresses.get(0);
                StringBuilder strReturnedAddress = new StringBuilder("");
                for (int i = 0; i <= returnedAddress.getMaxAddressLineIndex(); ++i) {
                    strReturnedAddress.append(returnedAddress.getAddressLine(i)).append(", ");
                }
                strAdd = strReturnedAddress.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strAdd;
    }
}

