/*
 * Decompiled with CFR 0.152.
 */
package com.brainx.piccroplibrary.BXHelpers;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.PermissionChecker;

public class BXPermissionManager {
    private static boolean hasSelfPermission(Context context, String permission2) {
        try {
            return PermissionChecker.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    public static boolean checkCameraPermission(Activity context) {
        return BXPermissionManager.hasSelfPermission((Context)context, "android.permission.CAMERA") && BXPermissionManager.hasSelfPermission((Context)context, "android.permission.READ_EXTERNAL_STORAGE");
    }

    public static boolean checkStoragePermission(Activity context) {
        return BXPermissionManager.hasSelfPermission((Context)context, "android.permission.READ_EXTERNAL_STORAGE") && BXPermissionManager.hasSelfPermission((Context)context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean checkManageDocumentPermission(Activity context) {
        return BXPermissionManager.hasSelfPermission((Context)context, "android.permission.MANAGE_DOCUMENTS");
    }

    public static void requestManageDocumentPermission(Activity activity, int MANAGE_DOCUMENTS_REQUEST_CODE) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.MANAGE_DOCUMENTS"}, (int)MANAGE_DOCUMENTS_REQUEST_CODE);
    }

    public static void requestStoragePermission(Activity activity, int STORAGE_PERMISSION_REQUEST_CODE) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)STORAGE_PERMISSION_REQUEST_CODE);
    }

    public static void askLocationPermission(Activity activity, int code) {
        if (!BXPermissionManager.checkLocationPermission(activity)) {
            BXPermissionManager.requestLocationPermission(activity, code);
        }
    }

    public static boolean checkLocationPermission(Activity activity) {
        return ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public static void requestLocationPermission(Activity activity, int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
    }
}

