/*
 * Decompiled with CFR 0.152.
 */
package com.brainx.piccroplibrary.BXAsyncTask;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BXSaveImageTask
extends AsyncTask<Void, Void, Boolean> {
    private String filePath;
    private Bitmap image;
    private ISaveImageTask mListener;

    public BXSaveImageTask(Bitmap bitmap, String path, ISaveImageTask listener) {
        this.image = bitmap;
        this.mListener = listener;
        this.filePath = path;
    }

    protected Boolean doInBackground(Void ... params) {
        try {
            String name = new File(this.filePath).getName();
            String baseUr = new File(this.filePath).getParentFile().toString();
            File myDir = new File(baseUr);
            myDir.mkdirs();
            String[] namelist = name.split("\\.(?=[^\\.]+$)");
            File file = new File(myDir, namelist[0] + ".jpg");
            FileOutputStream fOut = new FileOutputStream(file);
            this.image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fOut);
            fOut.flush();
            ((OutputStream)fOut).close();
            this.filePath = file.getPath();
            return true;
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    protected void onPostExecute(Boolean successful) {
        if (this.image != null) {
            this.image.recycle();
            this.image = null;
        }
        if (successful.booleanValue()) {
            this.mListener.onSuccessfulSave(this.filePath);
        } else {
            this.mListener.onSaveFailure();
        }
    }

    public static interface ISaveImageTask {
        public void onSuccessfulSave(String var1);

        public void onSaveFailure();
    }
}

