/*
 * Decompiled with CFR 0.152.
 */
package com.brainx.imagecroplibrary.BXActivity;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import com.brainx.imagecroplibrary.BXAsyncTask.BXSaveImageTask;
import com.brainx.imagecroplibrary.BXBaseClasses.BaseActivity;
import com.brainx.imagecroplibrary.BXHelpers.BXFilePath;
import com.brainx.imagecroplibrary.BXHelpers.BXPermissionManager;
import com.brainx.imagecroplibrary.BXHelpers.BXUtils;
import com.brainx.imagecroplibrary.R;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.io.IOException;

public class BXCropActivity
extends BaseActivity
implements CropImageView.OnCropImageCompleteListener,
BXSaveImageTask.ISaveImageTask {
    private static final int MAX_SIDE = 800;
    private static final int GALLERY_MAX_SIDE = 1000;
    private CropImageView cropImageView;
    private Uri sourceUri;
    private Uri destinationUri;
    private int aspectRatioX;
    private int aspectRatioY;
    private String destinationPath;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.setLayout(R.layout.activity_crop, R.id.toolbar, "Crop", true);
        super.onCreate(savedInstanceState);
        this.getIntentData();
        this.initViews();
        this.setListener();
        this.setAspectRatio();
        this.setImage();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.crop_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.done_crop) {
            this.cropImage();
        } else if (id2 == R.id.action_rotate_image) {
            this.rotateImageLeft();
        }
        return super.onOptionsItemSelected(item);
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.fade_out);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1212) {
            if (grantResults[0] == 0) {
                if (this.sourceUri != null) {
                    this.cropImageView.setImageBitmap(this.getScaledImage(this.sourceUri));
                }
            } else {
                Log.d((String)"crop", (String)("onRequestPermissionsResult: " + grantResults[0]));
            }
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }

    private void initViews() {
        this.cropImageView = (CropImageView)this.findViewById(R.id.cropImageView);
    }

    private void setListener() {
        this.cropImageView.setOnCropImageCompleteListener((CropImageView.OnCropImageCompleteListener)this);
    }

    private boolean storagePermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (BXPermissionManager.checkStoragePermission((Activity)this)) {
                return true;
            }
            BXPermissionManager.requestStoragePermission((Activity)this, 1212);
            return false;
        }
        return true;
    }

    private void getIntentData() {
        Intent intent = this.getIntent();
        this.sourceUri = Uri.parse((String)intent.getStringExtra("sourceUri"));
        this.destinationUri = Uri.parse((String)intent.getStringExtra("destinationUri"));
        this.aspectRatioX = intent.getIntExtra("aspectRatioX", 1);
        this.aspectRatioY = intent.getIntExtra("aspectRatioy", 1);
    }

    private void setAspectRatio() {
        this.cropImageView.setAspectRatio(this.aspectRatioX, this.aspectRatioY);
    }

    private void setImage() {
        if (this.storagePermission() && this.sourceUri != null) {
            this.cropImageView.setImageBitmap(this.getScaledImage(this.sourceUri));
        }
    }

    private Bitmap getScaledImage(Uri uri) {
        Bitmap bitmap = null;
        try {
            bitmap = BXUtils.getScaledImage(MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)uri), 1000);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    private void cropImage() {
        if (this.storagePermission()) {
            this.cropImageView.getCroppedImageAsync();
        }
    }

    private void rotateImageLeft() {
        this.cropImageView.rotateImage(90);
    }

    private void scan(String path) {
        MediaScannerConnection.scanFile((Context)this, (String[])new String[]{path}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

            public void onScanCompleted(String path, Uri uri) {
                Log.i((String)"ExternalStorage", (String)("Scanned " + path + ":"));
                Log.i((String)"ExternalStorage", (String)("-> uri=" + uri));
            }
        });
    }

    public void onCropImageComplete(CropImageView view, CropImageView.CropResult result) {
        Bitmap bitmap = BXUtils.getScaledImage(result.getBitmap(), 800);
        this.destinationPath = BXFilePath.getPath((Context)this, this.destinationUri);
        new BXSaveImageTask(bitmap, this.destinationPath, this).execute(new Void[0]);
    }

    @Override
    public void onSuccessfulSave(String filePath) {
        Intent data = new Intent();
        data.putExtra("destinationUri", filePath);
        this.setResult(-1, data);
        this.scan(this.destinationPath);
        this.finish();
    }

    @Override
    public void onSaveFailure() {
        this.setResult(0);
        this.finish();
    }
}

